<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMetaData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMetaData
 * @subpackage Structs
 */
class PaymentMetaData extends AbstractStructBase
{
    /**
     * The KeyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KeyName;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for PaymentMetaData
     * @uses PaymentMetaData::setKeyName()
     * @uses PaymentMetaData::setValue()
     * @param string $keyName
     * @param string $value
     */
    public function __construct($keyName = null, $value = null)
    {
        $this
            ->setKeyName($keyName)
            ->setValue($value);
    }
    /**
     * Get KeyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyName()
    {
        return isset($this->KeyName) ? $this->KeyName : null;
    }
    /**
     * Set KeyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyName
     * @return \StructType\PaymentMetaData
     */
    public function setKeyName($keyName = null)
    {
        // validation for constraint: string
        if (!is_null($keyName) && !is_string($keyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyName, true), gettype($keyName)), __LINE__);
        }
        if (is_null($keyName) || (is_array($keyName) && empty($keyName))) {
            unset($this->KeyName);
        } else {
            $this->KeyName = $keyName;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\PaymentMetaData
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
