<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR.FlightInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR.FlightInformation
 * @subpackage Structs
 */
class ModifyPNR_FlightInformation extends AbstractStructBase
{
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The FareInformationID
     * @var int
     */
    public $FareInformationID;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The CRSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CRSCode;
    /**
     * Constructor method for ModifyPNR.FlightInformation
     * @uses ModifyPNR_FlightInformation::setLogicalFlightID()
     * @uses ModifyPNR_FlightInformation::setDepartureDate()
     * @uses ModifyPNR_FlightInformation::setFareInformationID()
     * @uses ModifyPNR_FlightInformation::setRecordLocator()
     * @uses ModifyPNR_FlightInformation::setCRSCode()
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param int $fareInformationID
     * @param string $recordLocator
     * @param string $cRSCode
     */
    public function __construct($logicalFlightID = null, $departureDate = null, $fareInformationID = null, $recordLocator = null, $cRSCode = null)
    {
        $this
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setFareInformationID($fareInformationID)
            ->setRecordLocator($recordLocator)
            ->setCRSCode($cRSCode);
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\ModifyPNR_FlightInformation
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ModifyPNR_FlightInformation
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FareInformationID value
     * @return int|null
     */
    public function getFareInformationID()
    {
        return $this->FareInformationID;
    }
    /**
     * Set FareInformationID value
     * @param int $fareInformationID
     * @return \StructType\ModifyPNR_FlightInformation
     */
    public function setFareInformationID($fareInformationID = null)
    {
        // validation for constraint: int
        if (!is_null($fareInformationID) && !(is_int($fareInformationID) || ctype_digit($fareInformationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareInformationID, true), gettype($fareInformationID)), __LINE__);
        }
        $this->FareInformationID = $fareInformationID;
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\ModifyPNR_FlightInformation
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
    /**
     * Get CRSCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCRSCode()
    {
        return isset($this->CRSCode) ? $this->CRSCode : null;
    }
    /**
     * Set CRSCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cRSCode
     * @return \StructType\ModifyPNR_FlightInformation
     */
    public function setCRSCode($cRSCode = null)
    {
        // validation for constraint: string
        if (!is_null($cRSCode) && !is_string($cRSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSCode, true), gettype($cRSCode)), __LINE__);
        }
        if (is_null($cRSCode) || (is_array($cRSCode) && empty($cRSCode))) {
            unset($this->CRSCode);
        } else {
            $this->CRSCode = $cRSCode;
        }
        return $this;
    }
}
