<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddPenalties
     * Meta information extracted from the WSDL
     * - documentation: <summary> adds penalties based on supplied data. </summary> <param name="AddPenaltyRequest">header / detail info for penalties to add.</param>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPenalties $parameters
     * @return \StructType\AddPenaltiesResponse|bool
     */
    public function AddPenalties(\StructType\AddPenalties $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPenalties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTaxes
     * Meta information extracted from the WSDL
     * - documentation: <summary> adds taxes based on the given payload </summary> <param name="AddTaxRequest">header and detail data for the taxes to add.</param>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTaxes $parameters
     * @return \StructType\AddTaxesResponse|bool
     */
    public function AddTaxes(\StructType\AddTaxes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTaxes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUpdateApisInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUpdateApisInfo $parameters
     * @return \StructType\AddUpdateApisInfoResponse|bool
     */
    public function AddUpdateApisInfo(\StructType\AddUpdateApisInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUpdateApisInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddPenaltiesResponse|\StructType\AddTaxesResponse|\StructType\AddUpdateApisInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
