<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewImportPNR.Reservation.Segment.AirlinePerson.Seat
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewImportPNR.Reservation.Segment.AirlinePerson.Seat
 * @subpackage Structs
 */
class ViewImportPNR_Reservation_Segment_AirlinePerson_Seat extends AbstractStructBase
{
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowNumber;
    /**
     * Constructor method for ViewImportPNR.Reservation.Segment.AirlinePerson.Seat
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson_Seat::setPhysicalFlightID()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson_Seat::setSeat()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson_Seat::setRowNumber()
     * @param int $physicalFlightID
     * @param string $seat
     * @param int $rowNumber
     */
    public function __construct($physicalFlightID = null, $seat = null, $rowNumber = null)
    {
        $this
            ->setPhysicalFlightID($physicalFlightID)
            ->setSeat($seat)
            ->setRowNumber($rowNumber);
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson_Seat
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson_Seat
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson_Seat
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
}
