<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Segment
 * @subpackage Structs
 */
class Segment extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The FareInformationID
     * @var int
     */
    public $FareInformationID;
    /**
     * The MarketingCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarketingCode;
    /**
     * The StoreFrontID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StoreFrontID;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeat
     */
    public $Seats;
    /**
     * The CRSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CRSCode;
    /**
     * Constructor method for Segment
     * @uses Segment::setPersonOrgID()
     * @uses Segment::setFareInformationID()
     * @uses Segment::setMarketingCode()
     * @uses Segment::setStoreFrontID()
     * @uses Segment::setRecordLocator()
     * @uses Segment::setSpecialServices()
     * @uses Segment::setSeats()
     * @uses Segment::setCRSCode()
     * @param int $personOrgID
     * @param int $fareInformationID
     * @param string $marketingCode
     * @param string $storeFrontID
     * @param string $recordLocator
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @param \ArrayType\ArrayOfSeat $seats
     * @param string $cRSCode
     */
    public function __construct($personOrgID = null, $fareInformationID = null, $marketingCode = null, $storeFrontID = null, $recordLocator = null, \ArrayType\ArrayOfSpecialService $specialServices = null, \ArrayType\ArrayOfSeat $seats = null, $cRSCode = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setFareInformationID($fareInformationID)
            ->setMarketingCode($marketingCode)
            ->setStoreFrontID($storeFrontID)
            ->setRecordLocator($recordLocator)
            ->setSpecialServices($specialServices)
            ->setSeats($seats)
            ->setCRSCode($cRSCode);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\Segment
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get FareInformationID value
     * @return int|null
     */
    public function getFareInformationID()
    {
        return $this->FareInformationID;
    }
    /**
     * Set FareInformationID value
     * @param int $fareInformationID
     * @return \StructType\Segment
     */
    public function setFareInformationID($fareInformationID = null)
    {
        // validation for constraint: int
        if (!is_null($fareInformationID) && !(is_int($fareInformationID) || ctype_digit($fareInformationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareInformationID, true), gettype($fareInformationID)), __LINE__);
        }
        $this->FareInformationID = $fareInformationID;
        return $this;
    }
    /**
     * Get MarketingCode value
     * @return string|null
     */
    public function getMarketingCode()
    {
        return $this->MarketingCode;
    }
    /**
     * Set MarketingCode value
     * @param string $marketingCode
     * @return \StructType\Segment
     */
    public function setMarketingCode($marketingCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCode) && !is_string($marketingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCode, true), gettype($marketingCode)), __LINE__);
        }
        $this->MarketingCode = $marketingCode;
        return $this;
    }
    /**
     * Get StoreFrontID value
     * @return string|null
     */
    public function getStoreFrontID()
    {
        return $this->StoreFrontID;
    }
    /**
     * Set StoreFrontID value
     * @param string $storeFrontID
     * @return \StructType\Segment
     */
    public function setStoreFrontID($storeFrontID = null)
    {
        // validation for constraint: string
        if (!is_null($storeFrontID) && !is_string($storeFrontID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeFrontID, true), gettype($storeFrontID)), __LINE__);
        }
        $this->StoreFrontID = $storeFrontID;
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\Segment
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @return \StructType\Segment
     */
    public function setSpecialServices(\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Get Seats value
     * @return \ArrayType\ArrayOfSeat|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \ArrayType\ArrayOfSeat $seats
     * @return \StructType\Segment
     */
    public function setSeats(\ArrayType\ArrayOfSeat $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get CRSCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCRSCode()
    {
        return isset($this->CRSCode) ? $this->CRSCode : null;
    }
    /**
     * Set CRSCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cRSCode
     * @return \StructType\Segment
     */
    public function setCRSCode($cRSCode = null)
    {
        // validation for constraint: string
        if (!is_null($cRSCode) && !is_string($cRSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSCode, true), gettype($cRSCode)), __LINE__);
        }
        if (is_null($cRSCode) || (is_array($cRSCode) && empty($cRSCode))) {
            unset($this->CRSCode);
        } else {
            $this->CRSCode = $cRSCode;
        }
        return $this;
    }
}
