<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seat StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Seat
 * @subpackage Structs
 */
class Seat extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The PhysicalFlightID
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The SeatSelected
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeatSelected;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RowNumber;
    /**
     * The IsExtraSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExtraSeat;
    /**
     * Constructor method for Seat
     * @uses Seat::setPersonOrgID()
     * @uses Seat::setLogicalFlightID()
     * @uses Seat::setPhysicalFlightID()
     * @uses Seat::setDepartureDate()
     * @uses Seat::setSeatSelected()
     * @uses Seat::setRowNumber()
     * @uses Seat::setIsExtraSeat()
     * @param int $personOrgID
     * @param int $logicalFlightID
     * @param int $physicalFlightID
     * @param string $departureDate
     * @param string $seatSelected
     * @param string $rowNumber
     * @param bool $isExtraSeat
     */
    public function __construct($personOrgID = null, $logicalFlightID = null, $physicalFlightID = null, $departureDate = null, $seatSelected = null, $rowNumber = null, $isExtraSeat = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setLogicalFlightID($logicalFlightID)
            ->setPhysicalFlightID($physicalFlightID)
            ->setDepartureDate($departureDate)
            ->setSeatSelected($seatSelected)
            ->setRowNumber($rowNumber)
            ->setIsExtraSeat($isExtraSeat);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\Seat
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\Seat
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\Seat
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\Seat
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get SeatSelected value
     * @return string|null
     */
    public function getSeatSelected()
    {
        return $this->SeatSelected;
    }
    /**
     * Set SeatSelected value
     * @param string $seatSelected
     * @return \StructType\Seat
     */
    public function setSeatSelected($seatSelected = null)
    {
        // validation for constraint: string
        if (!is_null($seatSelected) && !is_string($seatSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatSelected, true), gettype($seatSelected)), __LINE__);
        }
        $this->SeatSelected = $seatSelected;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return string|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param string $rowNumber
     * @return \StructType\Seat
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($rowNumber) && !is_string($rowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get IsExtraSeat value
     * @return bool|null
     */
    public function getIsExtraSeat()
    {
        return $this->IsExtraSeat;
    }
    /**
     * Set IsExtraSeat value
     * @param bool $isExtraSeat
     * @return \StructType\Seat
     */
    public function setIsExtraSeat($isExtraSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraSeat) && !is_bool($isExtraSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraSeat, true), gettype($isExtraSeat)), __LINE__);
        }
        $this->IsExtraSeat = $isExtraSeat;
        return $this;
    }
}
