<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationByNationalId StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationByNationalId
 * @subpackage Structs
 */
class ReservationByNationalId extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingDate;
    /**
     * The PrimaryPassengerLastname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryPassengerLastname;
    /**
     * The NumPassengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumPassengers;
    /**
     * The FlightSegments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFlightSegment
     */
    public $FlightSegments;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Payments;
    /**
     * Constructor method for ReservationByNationalId
     * @uses ReservationByNationalId::setSeriesNumber()
     * @uses ReservationByNationalId::setConfirmationNumber()
     * @uses ReservationByNationalId::setBookingDate()
     * @uses ReservationByNationalId::setPrimaryPassengerLastname()
     * @uses ReservationByNationalId::setNumPassengers()
     * @uses ReservationByNationalId::setFlightSegments()
     * @uses ReservationByNationalId::setPayments()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $bookingDate
     * @param string $primaryPassengerLastname
     * @param int $numPassengers
     * @param \ArrayType\ArrayOfFlightSegment $flightSegments
     * @param string $payments
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $bookingDate = null, $primaryPassengerLastname = null, $numPassengers = null, \ArrayType\ArrayOfFlightSegment $flightSegments = null, $payments = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingDate($bookingDate)
            ->setPrimaryPassengerLastname($primaryPassengerLastname)
            ->setNumPassengers($numPassengers)
            ->setFlightSegments($flightSegments)
            ->setPayments($payments);
    }
    /**
     * Get SeriesNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return isset($this->SeriesNumber) ? $this->SeriesNumber : null;
    }
    /**
     * Set SeriesNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNumber
     * @return \StructType\ReservationByNationalId
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        if (is_null($seriesNumber) || (is_array($seriesNumber) && empty($seriesNumber))) {
            unset($this->SeriesNumber);
        } else {
            $this->SeriesNumber = $seriesNumber;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\ReservationByNationalId
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get BookingDate value
     * @return string|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param string $bookingDate
     * @return \StructType\ReservationByNationalId
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDate, true), gettype($bookingDate)), __LINE__);
        }
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get PrimaryPassengerLastname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryPassengerLastname()
    {
        return isset($this->PrimaryPassengerLastname) ? $this->PrimaryPassengerLastname : null;
    }
    /**
     * Set PrimaryPassengerLastname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryPassengerLastname
     * @return \StructType\ReservationByNationalId
     */
    public function setPrimaryPassengerLastname($primaryPassengerLastname = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPassengerLastname) && !is_string($primaryPassengerLastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryPassengerLastname, true), gettype($primaryPassengerLastname)), __LINE__);
        }
        if (is_null($primaryPassengerLastname) || (is_array($primaryPassengerLastname) && empty($primaryPassengerLastname))) {
            unset($this->PrimaryPassengerLastname);
        } else {
            $this->PrimaryPassengerLastname = $primaryPassengerLastname;
        }
        return $this;
    }
    /**
     * Get NumPassengers value
     * @return int|null
     */
    public function getNumPassengers()
    {
        return $this->NumPassengers;
    }
    /**
     * Set NumPassengers value
     * @param int $numPassengers
     * @return \StructType\ReservationByNationalId
     */
    public function setNumPassengers($numPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($numPassengers) && !(is_int($numPassengers) || ctype_digit($numPassengers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numPassengers, true), gettype($numPassengers)), __LINE__);
        }
        $this->NumPassengers = $numPassengers;
        return $this;
    }
    /**
     * Get FlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFlightSegment|null
     */
    public function getFlightSegments()
    {
        return isset($this->FlightSegments) ? $this->FlightSegments : null;
    }
    /**
     * Set FlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFlightSegment $flightSegments
     * @return \StructType\ReservationByNationalId
     */
    public function setFlightSegments(\ArrayType\ArrayOfFlightSegment $flightSegments = null)
    {
        if (is_null($flightSegments) || (is_array($flightSegments) && empty($flightSegments))) {
            unset($this->FlightSegments);
        } else {
            $this->FlightSegments = $flightSegments;
        }
        return $this;
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payments
     * @return \StructType\ReservationByNationalId
     */
    public function setPayments($payments = null)
    {
        // validation for constraint: string
        if (!is_null($payments) && !is_string($payments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payments, true), gettype($payments)), __LINE__);
        }
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
}
