<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverrideChargeBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverrideChargeBase
 * @subpackage Structs
 */
class OverrideChargeBase extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ChargeKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChargeKey;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The OriginalAmount
     * @var float
     */
    public $OriginalAmount;
    /**
     * The ExchangeRate
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateDate
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * The ChargeComment
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChargeComment;
    /**
     * The ChargeDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChargeDescription;
    /**
     * The OverrideReason
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OverrideReason;
    /**
     * The ExtPenaltyRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtPenaltyRule;
    /**
     * The ExtIsRepriceFixed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtIsRepriceFixed;
    /**
     * The ExtRepriceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtRepriceValue;
    /**
     * The ExtRepriceSourceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtRepriceSourceName;
    /**
     * The ExtRepriceValueReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtRepriceValueReason;
    /**
     * Constructor method for OverrideChargeBase
     * @uses OverrideChargeBase::setAmount()
     * @uses OverrideChargeBase::setChargeKey()
     * @uses OverrideChargeBase::setOriginalCurrency()
     * @uses OverrideChargeBase::setOriginalAmount()
     * @uses OverrideChargeBase::setExchangeRate()
     * @uses OverrideChargeBase::setExchangeRateDate()
     * @uses OverrideChargeBase::setChargeComment()
     * @uses OverrideChargeBase::setChargeDescription()
     * @uses OverrideChargeBase::setOverrideReason()
     * @uses OverrideChargeBase::setExtPenaltyRule()
     * @uses OverrideChargeBase::setExtIsRepriceFixed()
     * @uses OverrideChargeBase::setExtRepriceValue()
     * @uses OverrideChargeBase::setExtRepriceSourceName()
     * @uses OverrideChargeBase::setExtRepriceValueReason()
     * @param float $amount
     * @param string $chargeKey
     * @param string $originalCurrency
     * @param float $originalAmount
     * @param float $exchangeRate
     * @param string $exchangeRateDate
     * @param string $chargeComment
     * @param string $chargeDescription
     * @param string $overrideReason
     * @param string $extPenaltyRule
     * @param string $extIsRepriceFixed
     * @param string $extRepriceValue
     * @param string $extRepriceSourceName
     * @param string $extRepriceValueReason
     */
    public function __construct($amount = null, $chargeKey = null, $originalCurrency = null, $originalAmount = null, $exchangeRate = null, $exchangeRateDate = null, $chargeComment = null, $chargeDescription = null, $overrideReason = null, $extPenaltyRule = null, $extIsRepriceFixed = null, $extRepriceValue = null, $extRepriceSourceName = null, $extRepriceValueReason = null)
    {
        $this
            ->setAmount($amount)
            ->setChargeKey($chargeKey)
            ->setOriginalCurrency($originalCurrency)
            ->setOriginalAmount($originalAmount)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateDate($exchangeRateDate)
            ->setChargeComment($chargeComment)
            ->setChargeDescription($chargeDescription)
            ->setOverrideReason($overrideReason)
            ->setExtPenaltyRule($extPenaltyRule)
            ->setExtIsRepriceFixed($extIsRepriceFixed)
            ->setExtRepriceValue($extRepriceValue)
            ->setExtRepriceSourceName($extRepriceSourceName)
            ->setExtRepriceValueReason($extRepriceValueReason);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\OverrideChargeBase
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ChargeKey value
     * @return string|null
     */
    public function getChargeKey()
    {
        return $this->ChargeKey;
    }
    /**
     * Set ChargeKey value
     * @param string $chargeKey
     * @return \StructType\OverrideChargeBase
     */
    public function setChargeKey($chargeKey = null)
    {
        // validation for constraint: string
        if (!is_null($chargeKey) && !is_string($chargeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeKey, true), gettype($chargeKey)), __LINE__);
        }
        $this->ChargeKey = $chargeKey;
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return $this->OriginalCurrency;
    }
    /**
     * Set OriginalCurrency value
     * @param string $originalCurrency
     * @return \StructType\OverrideChargeBase
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        $this->OriginalCurrency = $originalCurrency;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\OverrideChargeBase
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\OverrideChargeBase
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->ExchangeRateDate;
    }
    /**
     * Set ExchangeRateDate value
     * @param string $exchangeRateDate
     * @return \StructType\OverrideChargeBase
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        $this->ExchangeRateDate = $exchangeRateDate;
        return $this;
    }
    /**
     * Get ChargeComment value
     * @return string|null
     */
    public function getChargeComment()
    {
        return $this->ChargeComment;
    }
    /**
     * Set ChargeComment value
     * @param string $chargeComment
     * @return \StructType\OverrideChargeBase
     */
    public function setChargeComment($chargeComment = null)
    {
        // validation for constraint: string
        if (!is_null($chargeComment) && !is_string($chargeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeComment, true), gettype($chargeComment)), __LINE__);
        }
        $this->ChargeComment = $chargeComment;
        return $this;
    }
    /**
     * Get ChargeDescription value
     * @return string|null
     */
    public function getChargeDescription()
    {
        return $this->ChargeDescription;
    }
    /**
     * Set ChargeDescription value
     * @param string $chargeDescription
     * @return \StructType\OverrideChargeBase
     */
    public function setChargeDescription($chargeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDescription) && !is_string($chargeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeDescription, true), gettype($chargeDescription)), __LINE__);
        }
        $this->ChargeDescription = $chargeDescription;
        return $this;
    }
    /**
     * Get OverrideReason value
     * @return string|null
     */
    public function getOverrideReason()
    {
        return $this->OverrideReason;
    }
    /**
     * Set OverrideReason value
     * @param string $overrideReason
     * @return \StructType\OverrideChargeBase
     */
    public function setOverrideReason($overrideReason = null)
    {
        // validation for constraint: string
        if (!is_null($overrideReason) && !is_string($overrideReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideReason, true), gettype($overrideReason)), __LINE__);
        }
        $this->OverrideReason = $overrideReason;
        return $this;
    }
    /**
     * Get ExtPenaltyRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtPenaltyRule()
    {
        return isset($this->ExtPenaltyRule) ? $this->ExtPenaltyRule : null;
    }
    /**
     * Set ExtPenaltyRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extPenaltyRule
     * @return \StructType\OverrideChargeBase
     */
    public function setExtPenaltyRule($extPenaltyRule = null)
    {
        // validation for constraint: string
        if (!is_null($extPenaltyRule) && !is_string($extPenaltyRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extPenaltyRule, true), gettype($extPenaltyRule)), __LINE__);
        }
        if (is_null($extPenaltyRule) || (is_array($extPenaltyRule) && empty($extPenaltyRule))) {
            unset($this->ExtPenaltyRule);
        } else {
            $this->ExtPenaltyRule = $extPenaltyRule;
        }
        return $this;
    }
    /**
     * Get ExtIsRepriceFixed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtIsRepriceFixed()
    {
        return isset($this->ExtIsRepriceFixed) ? $this->ExtIsRepriceFixed : null;
    }
    /**
     * Set ExtIsRepriceFixed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extIsRepriceFixed
     * @return \StructType\OverrideChargeBase
     */
    public function setExtIsRepriceFixed($extIsRepriceFixed = null)
    {
        // validation for constraint: string
        if (!is_null($extIsRepriceFixed) && !is_string($extIsRepriceFixed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extIsRepriceFixed, true), gettype($extIsRepriceFixed)), __LINE__);
        }
        if (is_null($extIsRepriceFixed) || (is_array($extIsRepriceFixed) && empty($extIsRepriceFixed))) {
            unset($this->ExtIsRepriceFixed);
        } else {
            $this->ExtIsRepriceFixed = $extIsRepriceFixed;
        }
        return $this;
    }
    /**
     * Get ExtRepriceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtRepriceValue()
    {
        return isset($this->ExtRepriceValue) ? $this->ExtRepriceValue : null;
    }
    /**
     * Set ExtRepriceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extRepriceValue
     * @return \StructType\OverrideChargeBase
     */
    public function setExtRepriceValue($extRepriceValue = null)
    {
        // validation for constraint: string
        if (!is_null($extRepriceValue) && !is_string($extRepriceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extRepriceValue, true), gettype($extRepriceValue)), __LINE__);
        }
        if (is_null($extRepriceValue) || (is_array($extRepriceValue) && empty($extRepriceValue))) {
            unset($this->ExtRepriceValue);
        } else {
            $this->ExtRepriceValue = $extRepriceValue;
        }
        return $this;
    }
    /**
     * Get ExtRepriceSourceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtRepriceSourceName()
    {
        return isset($this->ExtRepriceSourceName) ? $this->ExtRepriceSourceName : null;
    }
    /**
     * Set ExtRepriceSourceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extRepriceSourceName
     * @return \StructType\OverrideChargeBase
     */
    public function setExtRepriceSourceName($extRepriceSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($extRepriceSourceName) && !is_string($extRepriceSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extRepriceSourceName, true), gettype($extRepriceSourceName)), __LINE__);
        }
        if (is_null($extRepriceSourceName) || (is_array($extRepriceSourceName) && empty($extRepriceSourceName))) {
            unset($this->ExtRepriceSourceName);
        } else {
            $this->ExtRepriceSourceName = $extRepriceSourceName;
        }
        return $this;
    }
    /**
     * Get ExtRepriceValueReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtRepriceValueReason()
    {
        return isset($this->ExtRepriceValueReason) ? $this->ExtRepriceValueReason : null;
    }
    /**
     * Set ExtRepriceValueReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extRepriceValueReason
     * @return \StructType\OverrideChargeBase
     */
    public function setExtRepriceValueReason($extRepriceValueReason = null)
    {
        // validation for constraint: string
        if (!is_null($extRepriceValueReason) && !is_string($extRepriceValueReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extRepriceValueReason, true), gettype($extRepriceValueReason)), __LINE__);
        }
        if (is_null($extRepriceValueReason) || (is_array($extRepriceValueReason) && empty($extRepriceValueReason))) {
            unset($this->ExtRepriceValueReason);
        } else {
            $this->ExtRepriceValueReason = $extRepriceValueReason;
        }
        return $this;
    }
}
