<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OALAirlinePerson StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OALAirlinePerson
 * @subpackage Structs
 */
class OALAirlinePerson extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * Constructor method for OALAirlinePerson
     * @uses OALAirlinePerson::setPersonOrgID()
     * @uses OALAirlinePerson::setFareClass()
     * @param int $personOrgID
     * @param string $fareClass
     */
    public function __construct($personOrgID = null, $fareClass = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setFareClass($fareClass);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\OALAirlinePerson
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\OALAirlinePerson
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
}
