<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR.Person StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR.Person
 * @subpackage Structs
 */
class ModifyPNR_Person extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The DOB
     * @var string
     */
    public $DOB;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The NationalityLaguageID
     * @var int
     */
    public $NationalityLaguageID;
    /**
     * The RelationType
     * @var string
     */
    public $RelationType;
    /**
     * The WBCID
     * @var int
     */
    public $WBCID;
    /**
     * The PTCID
     * @var int
     */
    public $PTCID;
    /**
     * The PTC
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PTC;
    /**
     * The UseInventory
     * @var bool
     */
    public $UseInventory;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The Passport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Passport;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nationality;
    /**
     * The ProfileId
     * @var int
     */
    public $ProfileId;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfos;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Weight;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * Constructor method for ModifyPNR.Person
     * @uses ModifyPNR_Person::setPersonOrgID()
     * @uses ModifyPNR_Person::setFirstName()
     * @uses ModifyPNR_Person::setLastName()
     * @uses ModifyPNR_Person::setMiddleName()
     * @uses ModifyPNR_Person::setAge()
     * @uses ModifyPNR_Person::setDOB()
     * @uses ModifyPNR_Person::setGender()
     * @uses ModifyPNR_Person::setTitle()
     * @uses ModifyPNR_Person::setNationalityLaguageID()
     * @uses ModifyPNR_Person::setRelationType()
     * @uses ModifyPNR_Person::setWBCID()
     * @uses ModifyPNR_Person::setPTCID()
     * @uses ModifyPNR_Person::setPTC()
     * @uses ModifyPNR_Person::setUseInventory()
     * @uses ModifyPNR_Person::setAddress()
     * @uses ModifyPNR_Person::setCompany()
     * @uses ModifyPNR_Person::setComments()
     * @uses ModifyPNR_Person::setPassport()
     * @uses ModifyPNR_Person::setNationality()
     * @uses ModifyPNR_Person::setProfileId()
     * @uses ModifyPNR_Person::setContactInfos()
     * @uses ModifyPNR_Person::setWeight()
     * @uses ModifyPNR_Person::setHeight()
     * @param int $personOrgID
     * @param string $firstName
     * @param string $lastName
     * @param string $middleName
     * @param int $age
     * @param string $dOB
     * @param string $gender
     * @param string $title
     * @param int $nationalityLaguageID
     * @param string $relationType
     * @param int $wBCID
     * @param int $pTCID
     * @param string $pTC
     * @param bool $useInventory
     * @param \StructType\Address $address
     * @param string $company
     * @param string $comments
     * @param string $passport
     * @param string $nationality
     * @param int $profileId
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @param float $weight
     * @param int $height
     */
    public function __construct($personOrgID = null, $firstName = null, $lastName = null, $middleName = null, $age = null, $dOB = null, $gender = null, $title = null, $nationalityLaguageID = null, $relationType = null, $wBCID = null, $pTCID = null, $pTC = null, $useInventory = null, \StructType\Address $address = null, $company = null, $comments = null, $passport = null, $nationality = null, $profileId = null, \ArrayType\ArrayOfContactInfo $contactInfos = null, $weight = null, $height = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setAge($age)
            ->setDOB($dOB)
            ->setGender($gender)
            ->setTitle($title)
            ->setNationalityLaguageID($nationalityLaguageID)
            ->setRelationType($relationType)
            ->setWBCID($wBCID)
            ->setPTCID($pTCID)
            ->setPTC($pTC)
            ->setUseInventory($useInventory)
            ->setAddress($address)
            ->setCompany($company)
            ->setComments($comments)
            ->setPassport($passport)
            ->setNationality($nationality)
            ->setProfileId($profileId)
            ->setContactInfos($contactInfos)
            ->setWeight($weight)
            ->setHeight($height);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\ModifyPNR_Person
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ModifyPNR_Person
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ModifyPNR_Person
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\ModifyPNR_Person
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\ModifyPNR_Person
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\ModifyPNR_Person
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Enumerations_GenderTypes::valueIsValid()
     * @uses \EnumType\Enumerations_GenderTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\ModifyPNR_Person
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_GenderTypes::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_GenderTypes', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\Enumerations_GenderTypes::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ModifyPNR_Person
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get NationalityLaguageID value
     * @return int|null
     */
    public function getNationalityLaguageID()
    {
        return $this->NationalityLaguageID;
    }
    /**
     * Set NationalityLaguageID value
     * @param int $nationalityLaguageID
     * @return \StructType\ModifyPNR_Person
     */
    public function setNationalityLaguageID($nationalityLaguageID = null)
    {
        // validation for constraint: int
        if (!is_null($nationalityLaguageID) && !(is_int($nationalityLaguageID) || ctype_digit($nationalityLaguageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nationalityLaguageID, true), gettype($nationalityLaguageID)), __LINE__);
        }
        $this->NationalityLaguageID = $nationalityLaguageID;
        return $this;
    }
    /**
     * Get RelationType value
     * @return string|null
     */
    public function getRelationType()
    {
        return $this->RelationType;
    }
    /**
     * Set RelationType value
     * @uses \EnumType\Enumerations_RelationshipTypes::valueIsValid()
     * @uses \EnumType\Enumerations_RelationshipTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationType
     * @return \StructType\ModifyPNR_Person
     */
    public function setRelationType($relationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_RelationshipTypes::valueIsValid($relationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_RelationshipTypes', is_array($relationType) ? implode(', ', $relationType) : var_export($relationType, true), implode(', ', \EnumType\Enumerations_RelationshipTypes::getValidValues())), __LINE__);
        }
        $this->RelationType = $relationType;
        return $this;
    }
    /**
     * Get WBCID value
     * @return int|null
     */
    public function getWBCID()
    {
        return $this->WBCID;
    }
    /**
     * Set WBCID value
     * @param int $wBCID
     * @return \StructType\ModifyPNR_Person
     */
    public function setWBCID($wBCID = null)
    {
        // validation for constraint: int
        if (!is_null($wBCID) && !(is_int($wBCID) || ctype_digit($wBCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wBCID, true), gettype($wBCID)), __LINE__);
        }
        $this->WBCID = $wBCID;
        return $this;
    }
    /**
     * Get PTCID value
     * @return int|null
     */
    public function getPTCID()
    {
        return $this->PTCID;
    }
    /**
     * Set PTCID value
     * @param int $pTCID
     * @return \StructType\ModifyPNR_Person
     */
    public function setPTCID($pTCID = null)
    {
        // validation for constraint: int
        if (!is_null($pTCID) && !(is_int($pTCID) || ctype_digit($pTCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTCID, true), gettype($pTCID)), __LINE__);
        }
        $this->PTCID = $pTCID;
        return $this;
    }
    /**
     * Get PTC value
     * @return string|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * Set PTC value
     * @param string $pTC
     * @return \StructType\ModifyPNR_Person
     */
    public function setPTC($pTC = null)
    {
        // validation for constraint: string
        if (!is_null($pTC) && !is_string($pTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTC, true), gettype($pTC)), __LINE__);
        }
        $this->PTC = $pTC;
        return $this;
    }
    /**
     * Get UseInventory value
     * @return bool|null
     */
    public function getUseInventory()
    {
        return $this->UseInventory;
    }
    /**
     * Set UseInventory value
     * @param bool $useInventory
     * @return \StructType\ModifyPNR_Person
     */
    public function setUseInventory($useInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($useInventory) && !is_bool($useInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useInventory, true), gettype($useInventory)), __LINE__);
        }
        $this->UseInventory = $useInventory;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\ModifyPNR_Person
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\ModifyPNR_Person
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\ModifyPNR_Person
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Passport value
     * @return string|null
     */
    public function getPassport()
    {
        return $this->Passport;
    }
    /**
     * Set Passport value
     * @param string $passport
     * @return \StructType\ModifyPNR_Person
     */
    public function setPassport($passport = null)
    {
        // validation for constraint: string
        if (!is_null($passport) && !is_string($passport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passport, true), gettype($passport)), __LINE__);
        }
        $this->Passport = $passport;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\ModifyPNR_Person
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ModifyPNR_Person
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get ContactInfos value
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfos()
    {
        return $this->ContactInfos;
    }
    /**
     * Set ContactInfos value
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @return \StructType\ModifyPNR_Person
     */
    public function setContactInfos(\ArrayType\ArrayOfContactInfo $contactInfos = null)
    {
        $this->ContactInfos = $contactInfos;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\ModifyPNR_Person
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\ModifyPNR_Person
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
}
