<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPNR.Reservation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportPNR.Reservation
 * @subpackage Structs
 */
class ImportPNR_Reservation extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingAction
     * @var string
     */
    public $BookingAction;
    /**
     * The BookingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BookingCarrier;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The ExternalAppID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalAppID;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The OriginalBookingDate
     * @var string
     */
    public $OriginalBookingDate;
    /**
     * The ReservationCurrency
     * @var string
     */
    public $ReservationCurrency;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The RecieptLanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RecieptLanguageCode;
    /**
     * The ReservationChannel
     * @var int
     */
    public $ReservationChannel;
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportPNR_Reservation_Segment
     */
    public $Segments;
    /**
     * The Persons
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportPNR_Reservation_Person
     */
    public $Persons;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportPNR_Reservation_Comment
     */
    public $Comments;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportPNR_Reservation_ImportError
     */
    public $Errors;
    /**
     * The OALSegments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOALSegment
     */
    public $OALSegments;
    /**
     * Constructor method for ImportPNR.Reservation
     * @uses ImportPNR_Reservation::setSeriesNumber()
     * @uses ImportPNR_Reservation::setConfirmationNumber()
     * @uses ImportPNR_Reservation::setBookingAction()
     * @uses ImportPNR_Reservation::setBookingCarrier()
     * @uses ImportPNR_Reservation::setIATANumber()
     * @uses ImportPNR_Reservation::setExternalAppID()
     * @uses ImportPNR_Reservation::setExternalBookingReference()
     * @uses ImportPNR_Reservation::setOriginalBookingDate()
     * @uses ImportPNR_Reservation::setReservationCurrency()
     * @uses ImportPNR_Reservation::setUser()
     * @uses ImportPNR_Reservation::setPromoCode()
     * @uses ImportPNR_Reservation::setRecieptLanguageCode()
     * @uses ImportPNR_Reservation::setReservationChannel()
     * @uses ImportPNR_Reservation::setSegments()
     * @uses ImportPNR_Reservation::setPersons()
     * @uses ImportPNR_Reservation::setComments()
     * @uses ImportPNR_Reservation::setErrors()
     * @uses ImportPNR_Reservation::setOALSegments()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $bookingAction
     * @param string $bookingCarrier
     * @param string $iATANumber
     * @param string $externalAppID
     * @param string $externalBookingReference
     * @param string $originalBookingDate
     * @param string $reservationCurrency
     * @param string $user
     * @param string $promoCode
     * @param string $recieptLanguageCode
     * @param int $reservationChannel
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Segment $segments
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Person $persons
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Comment $comments
     * @param \ArrayType\ArrayOfImportPNR_Reservation_ImportError $errors
     * @param \ArrayType\ArrayOfOALSegment $oALSegments
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $bookingAction = null, $bookingCarrier = null, $iATANumber = null, $externalAppID = null, $externalBookingReference = null, $originalBookingDate = null, $reservationCurrency = null, $user = null, $promoCode = null, $recieptLanguageCode = null, $reservationChannel = null, \ArrayType\ArrayOfImportPNR_Reservation_Segment $segments = null, \ArrayType\ArrayOfImportPNR_Reservation_Person $persons = null, \ArrayType\ArrayOfImportPNR_Reservation_Comment $comments = null, \ArrayType\ArrayOfImportPNR_Reservation_ImportError $errors = null, \ArrayType\ArrayOfOALSegment $oALSegments = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingAction($bookingAction)
            ->setBookingCarrier($bookingCarrier)
            ->setIATANumber($iATANumber)
            ->setExternalAppID($externalAppID)
            ->setExternalBookingReference($externalBookingReference)
            ->setOriginalBookingDate($originalBookingDate)
            ->setReservationCurrency($reservationCurrency)
            ->setUser($user)
            ->setPromoCode($promoCode)
            ->setRecieptLanguageCode($recieptLanguageCode)
            ->setReservationChannel($reservationChannel)
            ->setSegments($segments)
            ->setPersons($persons)
            ->setComments($comments)
            ->setErrors($errors)
            ->setOALSegments($oALSegments);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ImportPNR_Reservation
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ImportPNR_Reservation
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get BookingAction value
     * @return string|null
     */
    public function getBookingAction()
    {
        return $this->BookingAction;
    }
    /**
     * Set BookingAction value
     * @uses \EnumType\Enumerations_ImportBookingAction::valueIsValid()
     * @uses \EnumType\Enumerations_ImportBookingAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingAction
     * @return \StructType\ImportPNR_Reservation
     */
    public function setBookingAction($bookingAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ImportBookingAction::valueIsValid($bookingAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ImportBookingAction', is_array($bookingAction) ? implode(', ', $bookingAction) : var_export($bookingAction, true), implode(', ', \EnumType\Enumerations_ImportBookingAction::getValidValues())), __LINE__);
        }
        $this->BookingAction = $bookingAction;
        return $this;
    }
    /**
     * Get BookingCarrier value
     * @return string|null
     */
    public function getBookingCarrier()
    {
        return $this->BookingCarrier;
    }
    /**
     * Set BookingCarrier value
     * @param string $bookingCarrier
     * @return \StructType\ImportPNR_Reservation
     */
    public function setBookingCarrier($bookingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCarrier) && !is_string($bookingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCarrier, true), gettype($bookingCarrier)), __LINE__);
        }
        $this->BookingCarrier = $bookingCarrier;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \StructType\ImportPNR_Reservation
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get ExternalAppID value
     * @return string|null
     */
    public function getExternalAppID()
    {
        return $this->ExternalAppID;
    }
    /**
     * Set ExternalAppID value
     * @param string $externalAppID
     * @return \StructType\ImportPNR_Reservation
     */
    public function setExternalAppID($externalAppID = null)
    {
        // validation for constraint: string
        if (!is_null($externalAppID) && !is_string($externalAppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAppID, true), gettype($externalAppID)), __LINE__);
        }
        $this->ExternalAppID = $externalAppID;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\ImportPNR_Reservation
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get OriginalBookingDate value
     * @return string|null
     */
    public function getOriginalBookingDate()
    {
        return $this->OriginalBookingDate;
    }
    /**
     * Set OriginalBookingDate value
     * @param string $originalBookingDate
     * @return \StructType\ImportPNR_Reservation
     */
    public function setOriginalBookingDate($originalBookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalBookingDate) && !is_string($originalBookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalBookingDate, true), gettype($originalBookingDate)), __LINE__);
        }
        $this->OriginalBookingDate = $originalBookingDate;
        return $this;
    }
    /**
     * Get ReservationCurrency value
     * @return string|null
     */
    public function getReservationCurrency()
    {
        return $this->ReservationCurrency;
    }
    /**
     * Set ReservationCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationCurrency
     * @return \StructType\ImportPNR_Reservation
     */
    public function setReservationCurrency($reservationCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($reservationCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($reservationCurrency) ? implode(', ', $reservationCurrency) : var_export($reservationCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->ReservationCurrency = $reservationCurrency;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ImportPNR_Reservation
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get PromoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \StructType\ImportPNR_Reservation
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get RecieptLanguageCode value
     * @return string|null
     */
    public function getRecieptLanguageCode()
    {
        return $this->RecieptLanguageCode;
    }
    /**
     * Set RecieptLanguageCode value
     * @param string $recieptLanguageCode
     * @return \StructType\ImportPNR_Reservation
     */
    public function setRecieptLanguageCode($recieptLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($recieptLanguageCode) && !is_string($recieptLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recieptLanguageCode, true), gettype($recieptLanguageCode)), __LINE__);
        }
        $this->RecieptLanguageCode = $recieptLanguageCode;
        return $this;
    }
    /**
     * Get ReservationChannel value
     * @return int|null
     */
    public function getReservationChannel()
    {
        return $this->ReservationChannel;
    }
    /**
     * Set ReservationChannel value
     * @param int $reservationChannel
     * @return \StructType\ImportPNR_Reservation
     */
    public function setReservationChannel($reservationChannel = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChannel) && !(is_int($reservationChannel) || ctype_digit($reservationChannel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChannel, true), gettype($reservationChannel)), __LINE__);
        }
        $this->ReservationChannel = $reservationChannel;
        return $this;
    }
    /**
     * Get Segments value
     * @return \ArrayType\ArrayOfImportPNR_Reservation_Segment|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Segment $segments
     * @return \StructType\ImportPNR_Reservation
     */
    public function setSegments(\ArrayType\ArrayOfImportPNR_Reservation_Segment $segments = null)
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Get Persons value
     * @return \ArrayType\ArrayOfImportPNR_Reservation_Person|null
     */
    public function getPersons()
    {
        return $this->Persons;
    }
    /**
     * Set Persons value
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Person $persons
     * @return \StructType\ImportPNR_Reservation
     */
    public function setPersons(\ArrayType\ArrayOfImportPNR_Reservation_Person $persons = null)
    {
        $this->Persons = $persons;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfImportPNR_Reservation_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Comment $comments
     * @return \StructType\ImportPNR_Reservation
     */
    public function setComments(\ArrayType\ArrayOfImportPNR_Reservation_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfImportPNR_Reservation_ImportError|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfImportPNR_Reservation_ImportError $errors
     * @return \StructType\ImportPNR_Reservation
     */
    public function setErrors(\ArrayType\ArrayOfImportPNR_Reservation_ImportError $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get OALSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOALSegment|null
     */
    public function getOALSegments()
    {
        return isset($this->OALSegments) ? $this->OALSegments : null;
    }
    /**
     * Set OALSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOALSegment $oALSegments
     * @return \StructType\ImportPNR_Reservation
     */
    public function setOALSegments(\ArrayType\ArrayOfOALSegment $oALSegments = null)
    {
        if (is_null($oALSegments) || (is_array($oALSegments) && empty($oALSegments))) {
            unset($this->OALSegments);
        } else {
            $this->OALSegments = $oALSegments;
        }
        return $this;
    }
}
