<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportPNR
 * @subpackage Structs
 */
class ImportPNR extends TransactionInfo
{
    /**
     * The ImportPNRRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportPNR
     */
    public $ImportPNRRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ImportPNR
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ImportPNR_Reservation
     */
    public $ImportPNR;
    /**
     * Constructor method for ImportPNR
     * @uses ImportPNR::setImportPNRRequest()
     * @uses ImportPNR::setActionType()
     * @uses ImportPNR::setImportPNR()
     * @param \StructType\ImportPNR $importPNRRequest
     * @param string $actionType
     * @param \StructType\ImportPNR_Reservation $importPNR
     */
    public function __construct(\StructType\ImportPNR $importPNRRequest = null, $actionType = null, \StructType\ImportPNR_Reservation $importPNR = null)
    {
        $this
            ->setImportPNRRequest($importPNRRequest)
            ->setActionType($actionType)
            ->setImportPNR($importPNR);
    }
    /**
     * Get ImportPNRRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportPNR|null
     */
    public function getImportPNRRequest()
    {
        return isset($this->ImportPNRRequest) ? $this->ImportPNRRequest : null;
    }
    /**
     * Set ImportPNRRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportPNR $importPNRRequest
     * @return \StructType\ImportPNR
     */
    public function setImportPNRRequest(\StructType\ImportPNR $importPNRRequest = null)
    {
        if (is_null($importPNRRequest) || (is_array($importPNRRequest) && empty($importPNRRequest))) {
            unset($this->ImportPNRRequest);
        } else {
            $this->ImportPNRRequest = $importPNRRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ImportPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\ImportPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ImportPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImportPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\ImportPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ImportPNR value
     * @return \StructType\ImportPNR_Reservation|null
     */
    public function getImportPNR()
    {
        return $this->ImportPNR;
    }
    /**
     * Set ImportPNR value
     * @param \StructType\ImportPNR_Reservation $importPNR
     * @return \StructType\ImportPNR
     */
    public function setImportPNR(\StructType\ImportPNR_Reservation $importPNR = null)
    {
        $this->ImportPNR = $importPNR;
        return $this;
    }
}
