<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReservationsByNationalId StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetReservationsByNationalId
 * @subpackage Structs
 */
class GetReservationsByNationalId extends TransactionInfo
{
    /**
     * The GetReservationsByNationalIdRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetReservationsByNationalId
     */
    public $GetReservationsByNationalIdRequest;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The NationalId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $NationalId;
    /**
     * The ActiveOnly
     * @var bool
     */
    public $ActiveOnly;
    /**
     * Constructor method for GetReservationsByNationalId
     * @uses GetReservationsByNationalId::setGetReservationsByNationalIdRequest()
     * @uses GetReservationsByNationalId::setSeriesNumber()
     * @uses GetReservationsByNationalId::setNationalId()
     * @uses GetReservationsByNationalId::setActiveOnly()
     * @param \StructType\GetReservationsByNationalId $getReservationsByNationalIdRequest
     * @param string $seriesNumber
     * @param string $nationalId
     * @param bool $activeOnly
     */
    public function __construct(\StructType\GetReservationsByNationalId $getReservationsByNationalIdRequest = null, $seriesNumber = null, $nationalId = null, $activeOnly = null)
    {
        $this
            ->setGetReservationsByNationalIdRequest($getReservationsByNationalIdRequest)
            ->setSeriesNumber($seriesNumber)
            ->setNationalId($nationalId)
            ->setActiveOnly($activeOnly);
    }
    /**
     * Get GetReservationsByNationalIdRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetReservationsByNationalId|null
     */
    public function getGetReservationsByNationalIdRequest()
    {
        return isset($this->GetReservationsByNationalIdRequest) ? $this->GetReservationsByNationalIdRequest : null;
    }
    /**
     * Set GetReservationsByNationalIdRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetReservationsByNationalId $getReservationsByNationalIdRequest
     * @return \StructType\GetReservationsByNationalId
     */
    public function setGetReservationsByNationalIdRequest(\StructType\GetReservationsByNationalId $getReservationsByNationalIdRequest = null)
    {
        if (is_null($getReservationsByNationalIdRequest) || (is_array($getReservationsByNationalIdRequest) && empty($getReservationsByNationalIdRequest))) {
            unset($this->GetReservationsByNationalIdRequest);
        } else {
            $this->GetReservationsByNationalIdRequest = $getReservationsByNationalIdRequest;
        }
        return $this;
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\GetReservationsByNationalId
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get NationalId value
     * @return string|null
     */
    public function getNationalId()
    {
        return $this->NationalId;
    }
    /**
     * Set NationalId value
     * @param string $nationalId
     * @return \StructType\GetReservationsByNationalId
     */
    public function setNationalId($nationalId = null)
    {
        // validation for constraint: string
        if (!is_null($nationalId) && !is_string($nationalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalId, true), gettype($nationalId)), __LINE__);
        }
        $this->NationalId = $nationalId;
        return $this;
    }
    /**
     * Get ActiveOnly value
     * @return bool|null
     */
    public function getActiveOnly()
    {
        return $this->ActiveOnly;
    }
    /**
     * Set ActiveOnly value
     * @param bool $activeOnly
     * @return \StructType\GetReservationsByNationalId
     */
    public function setActiveOnly($activeOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeOnly) && !is_bool($activeOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeOnly, true), gettype($activeOnly)), __LINE__);
        }
        $this->ActiveOnly = $activeOnly;
        return $this;
    }
}
