<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EvaluateModificationOfPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EvaluateModificationOfPNR
 * @subpackage Structs
 */
class EvaluateModificationOfPNR extends TransactionInfo
{
    /**
     * The EvaluateModificationOfPNRRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EvaluateModificationOfPNR
     */
    public $EvaluateModificationOfPNRRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The LogicalFlightKeyToRemove
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKeyToRemove;
    /**
     * The PersonOrgIdentifierToRemove
     * @var int
     */
    public $PersonOrgIdentifierToRemove;
    /**
     * Constructor method for EvaluateModificationOfPNR
     * @uses EvaluateModificationOfPNR::setEvaluateModificationOfPNRRequest()
     * @uses EvaluateModificationOfPNR::setReservationInfo()
     * @uses EvaluateModificationOfPNR::setActionType()
     * @uses EvaluateModificationOfPNR::setLogicalFlightKeyToRemove()
     * @uses EvaluateModificationOfPNR::setPersonOrgIdentifierToRemove()
     * @param \StructType\EvaluateModificationOfPNR $evaluateModificationOfPNRRequest
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $actionType
     * @param string $logicalFlightKeyToRemove
     * @param int $personOrgIdentifierToRemove
     */
    public function __construct(\StructType\EvaluateModificationOfPNR $evaluateModificationOfPNRRequest = null, \StructType\ReservationInfo $reservationInfo = null, $actionType = null, $logicalFlightKeyToRemove = null, $personOrgIdentifierToRemove = null)
    {
        $this
            ->setEvaluateModificationOfPNRRequest($evaluateModificationOfPNRRequest)
            ->setReservationInfo($reservationInfo)
            ->setActionType($actionType)
            ->setLogicalFlightKeyToRemove($logicalFlightKeyToRemove)
            ->setPersonOrgIdentifierToRemove($personOrgIdentifierToRemove);
    }
    /**
     * Get EvaluateModificationOfPNRRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EvaluateModificationOfPNR|null
     */
    public function getEvaluateModificationOfPNRRequest()
    {
        return isset($this->EvaluateModificationOfPNRRequest) ? $this->EvaluateModificationOfPNRRequest : null;
    }
    /**
     * Set EvaluateModificationOfPNRRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EvaluateModificationOfPNR $evaluateModificationOfPNRRequest
     * @return \StructType\EvaluateModificationOfPNR
     */
    public function setEvaluateModificationOfPNRRequest(\StructType\EvaluateModificationOfPNR $evaluateModificationOfPNRRequest = null)
    {
        if (is_null($evaluateModificationOfPNRRequest) || (is_array($evaluateModificationOfPNRRequest) && empty($evaluateModificationOfPNRRequest))) {
            unset($this->EvaluateModificationOfPNRRequest);
        } else {
            $this->EvaluateModificationOfPNRRequest = $evaluateModificationOfPNRRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\EvaluateModificationOfPNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\EvaluateModificationOfPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\EvaluateModificationOfPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\EvaluateModificationOfPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EvaluateModificationOfPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EvaluateModificationOfPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\EvaluateModificationOfPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get LogicalFlightKeyToRemove value
     * @return string|null
     */
    public function getLogicalFlightKeyToRemove()
    {
        return $this->LogicalFlightKeyToRemove;
    }
    /**
     * Set LogicalFlightKeyToRemove value
     * @param string $logicalFlightKeyToRemove
     * @return \StructType\EvaluateModificationOfPNR
     */
    public function setLogicalFlightKeyToRemove($logicalFlightKeyToRemove = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKeyToRemove) && !is_string($logicalFlightKeyToRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKeyToRemove, true), gettype($logicalFlightKeyToRemove)), __LINE__);
        }
        $this->LogicalFlightKeyToRemove = $logicalFlightKeyToRemove;
        return $this;
    }
    /**
     * Get PersonOrgIdentifierToRemove value
     * @return int|null
     */
    public function getPersonOrgIdentifierToRemove()
    {
        return $this->PersonOrgIdentifierToRemove;
    }
    /**
     * Set PersonOrgIdentifierToRemove value
     * @param int $personOrgIdentifierToRemove
     * @return \StructType\EvaluateModificationOfPNR
     */
    public function setPersonOrgIdentifierToRemove($personOrgIdentifierToRemove = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgIdentifierToRemove) && !(is_int($personOrgIdentifierToRemove) || ctype_digit($personOrgIdentifierToRemove))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgIdentifierToRemove, true), gettype($personOrgIdentifierToRemove)), __LINE__);
        }
        $this->PersonOrgIdentifierToRemove = $personOrgIdentifierToRemove;
        return $this;
    }
}
