<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePNR
 * @subpackage Structs
 */
class CreatePNR extends TransactionInfo
{
    /**
     * The CreatePnrRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreatePNR
     */
    public $CreatePnrRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * Constructor method for CreatePNR
     * @uses CreatePNR::setCreatePnrRequest()
     * @uses CreatePNR::setActionType()
     * @uses CreatePNR::setReservationInfo()
     * @param \StructType\CreatePNR $createPnrRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     */
    public function __construct(\StructType\CreatePNR $createPnrRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null)
    {
        $this
            ->setCreatePnrRequest($createPnrRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo);
    }
    /**
     * Get CreatePnrRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreatePNR|null
     */
    public function getCreatePnrRequest()
    {
        return isset($this->CreatePnrRequest) ? $this->CreatePnrRequest : null;
    }
    /**
     * Set CreatePnrRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreatePNR $createPnrRequest
     * @return \StructType\CreatePNR
     */
    public function setCreatePnrRequest(\StructType\CreatePNR $createPnrRequest = null)
    {
        if (is_null($createPnrRequest) || (is_array($createPnrRequest) && empty($createPnrRequest))) {
            unset($this->CreatePnrRequest);
        } else {
            $this->CreatePnrRequest = $createPnrRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\CreatePNR_ActionTypes::valueIsValid()
     * @uses \EnumType\CreatePNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\CreatePNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreatePNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreatePNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\CreatePNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\CreatePNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
}
