<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Comment
 * @subpackage Structs
 */
class Comment extends AbstractStructBase
{
    /**
     * The CommentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommentID;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The CommentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommentDate;
    /**
     * The CommentLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommentLength;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * Constructor method for Comment
     * @uses Comment::setCommentID()
     * @uses Comment::setComment()
     * @uses Comment::setKey()
     * @uses Comment::setCommentDate()
     * @uses Comment::setCommentLength()
     * @uses Comment::setUserID()
     * @param int $commentID
     * @param string $comment
     * @param string $key
     * @param string $commentDate
     * @param int $commentLength
     * @param string $userID
     */
    public function __construct($commentID = null, $comment = null, $key = null, $commentDate = null, $commentLength = null, $userID = null)
    {
        $this
            ->setCommentID($commentID)
            ->setComment($comment)
            ->setKey($key)
            ->setCommentDate($commentDate)
            ->setCommentLength($commentLength)
            ->setUserID($userID);
    }
    /**
     * Get CommentID value
     * @return int|null
     */
    public function getCommentID()
    {
        return $this->CommentID;
    }
    /**
     * Set CommentID value
     * @param int $commentID
     * @return \StructType\Comment
     */
    public function setCommentID($commentID = null)
    {
        // validation for constraint: int
        if (!is_null($commentID) && !(is_int($commentID) || ctype_digit($commentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commentID, true), gettype($commentID)), __LINE__);
        }
        $this->CommentID = $commentID;
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\Comment
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Comment
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get CommentDate value
     * @return string|null
     */
    public function getCommentDate()
    {
        return $this->CommentDate;
    }
    /**
     * Set CommentDate value
     * @param string $commentDate
     * @return \StructType\Comment
     */
    public function setCommentDate($commentDate = null)
    {
        // validation for constraint: string
        if (!is_null($commentDate) && !is_string($commentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentDate, true), gettype($commentDate)), __LINE__);
        }
        $this->CommentDate = $commentDate;
        return $this;
    }
    /**
     * Get CommentLength value
     * @return int|null
     */
    public function getCommentLength()
    {
        return $this->CommentLength;
    }
    /**
     * Set CommentLength value
     * @param int $commentLength
     * @return \StructType\Comment
     */
    public function setCommentLength($commentLength = null)
    {
        // validation for constraint: int
        if (!is_null($commentLength) && !(is_int($commentLength) || ctype_digit($commentLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commentLength, true), gettype($commentLength)), __LINE__);
        }
        $this->CommentLength = $commentLength;
        return $this;
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \StructType\Comment
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
}
