<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApisInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApisInformation
 * @subpackage Structs
 */
class ApisInformation extends AbstractStructBase
{
    /**
     * The ApisInfoIndex
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $ApisInfoIndex;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $RecordNumber;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The Citizenship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Citizenship;
    /**
     * The ResidenceCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenceCountry;
    /**
     * The HomeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeAddress;
    /**
     * The HomeCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeCity;
    /**
     * The HomeState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeState;
    /**
     * The HomePostal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePostal;
    /**
     * The DestinationAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAddress;
    /**
     * The DestinationCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCity;
    /**
     * The DestinationState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationState;
    /**
     * The DestinationPostal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationPostal;
    /**
     * The DestinationCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCountry;
    /**
     * The Embarkation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Embarkation;
    /**
     * The BirthCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthCity;
    /**
     * The BirthState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthState;
    /**
     * The BirthCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthCountry;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The DocumentType1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DocumentType1;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber;
    /**
     * The IssueCountry1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueCountry1;
    /**
     * The ExpirationDate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate1;
    /**
     * The DocumentType2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DocumentType2;
    /**
     * The DocumentNumber2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber2;
    /**
     * The IssueCountry2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueCountry2;
    /**
     * The ExpirationDate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate2;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResultCode;
    /**
     * The PhysicalFlightId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhysicalFlightId;
    /**
     * The ActualDepartureDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ActualDepartureDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The Debarkation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Debarkation;
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Arrival;
    /**
     * The DocumentScanned1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $DocumentScanned1;
    /**
     * The DocumentScanned2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $DocumentScanned2;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The PaxInfo_Validated
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaxInfo_Validated;
    /**
     * The Info_Transmitted
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Info_Transmitted;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhysicalFlightID;
    /**
     * Constructor method for ApisInformation
     * @uses ApisInformation::setApisInfoIndex()
     * @uses ApisInformation::setRecordNumber()
     * @uses ApisInformation::setLastName()
     * @uses ApisInformation::setFirstName()
     * @uses ApisInformation::setMiddleName()
     * @uses ApisInformation::setBirthDate()
     * @uses ApisInformation::setGender()
     * @uses ApisInformation::setCitizenship()
     * @uses ApisInformation::setResidenceCountry()
     * @uses ApisInformation::setHomeAddress()
     * @uses ApisInformation::setHomeCity()
     * @uses ApisInformation::setHomeState()
     * @uses ApisInformation::setHomePostal()
     * @uses ApisInformation::setDestinationAddress()
     * @uses ApisInformation::setDestinationCity()
     * @uses ApisInformation::setDestinationState()
     * @uses ApisInformation::setDestinationPostal()
     * @uses ApisInformation::setDestinationCountry()
     * @uses ApisInformation::setEmbarkation()
     * @uses ApisInformation::setBirthCity()
     * @uses ApisInformation::setBirthState()
     * @uses ApisInformation::setBirthCountry()
     * @uses ApisInformation::setStatus()
     * @uses ApisInformation::setDocumentType1()
     * @uses ApisInformation::setDocumentNumber()
     * @uses ApisInformation::setIssueCountry1()
     * @uses ApisInformation::setExpirationDate1()
     * @uses ApisInformation::setDocumentType2()
     * @uses ApisInformation::setDocumentNumber2()
     * @uses ApisInformation::setIssueCountry2()
     * @uses ApisInformation::setExpirationDate2()
     * @uses ApisInformation::setResultCode()
     * @uses ApisInformation::setPhysicalFlightId()
     * @uses ApisInformation::setActualDepartureDate()
     * @uses ApisInformation::setFlightNumber()
     * @uses ApisInformation::setDebarkation()
     * @uses ApisInformation::setArrival()
     * @uses ApisInformation::setDocumentScanned1()
     * @uses ApisInformation::setDocumentScanned2()
     * @uses ApisInformation::setSeriesNumber()
     * @uses ApisInformation::setConfirmationNumber()
     * @uses ApisInformation::setPaxInfo_Validated()
     * @uses ApisInformation::setInfo_Transmitted()
     * @uses ApisInformation::setPhysicalFlightID_1()
     * @param int $apisInfoIndex
     * @param int $recordNumber
     * @param string $lastName
     * @param string $firstName
     * @param string $middleName
     * @param string $birthDate
     * @param string $gender
     * @param string $citizenship
     * @param string $residenceCountry
     * @param string $homeAddress
     * @param string $homeCity
     * @param string $homeState
     * @param string $homePostal
     * @param string $destinationAddress
     * @param string $destinationCity
     * @param string $destinationState
     * @param string $destinationPostal
     * @param string $destinationCountry
     * @param string $embarkation
     * @param string $birthCity
     * @param string $birthState
     * @param string $birthCountry
     * @param string $status
     * @param int $documentType1
     * @param string $documentNumber
     * @param string $issueCountry1
     * @param string $expirationDate1
     * @param int $documentType2
     * @param string $documentNumber2
     * @param string $issueCountry2
     * @param string $expirationDate2
     * @param int $resultCode
     * @param string $physicalFlightId
     * @param string $actualDepartureDate
     * @param string $flightNumber
     * @param string $debarkation
     * @param string $arrival
     * @param int $documentScanned1
     * @param int $documentScanned2
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $paxInfo_Validated
     * @param string $info_Transmitted
     * @param string $physicalFlightID
     */
    public function __construct($apisInfoIndex = null, $recordNumber = null, $lastName = null, $firstName = null, $middleName = null, $birthDate = null, $gender = null, $citizenship = null, $residenceCountry = null, $homeAddress = null, $homeCity = null, $homeState = null, $homePostal = null, $destinationAddress = null, $destinationCity = null, $destinationState = null, $destinationPostal = null, $destinationCountry = null, $embarkation = null, $birthCity = null, $birthState = null, $birthCountry = null, $status = null, $documentType1 = null, $documentNumber = null, $issueCountry1 = null, $expirationDate1 = null, $documentType2 = null, $documentNumber2 = null, $issueCountry2 = null, $expirationDate2 = null, $resultCode = null, $physicalFlightId = null, $actualDepartureDate = null, $flightNumber = null, $debarkation = null, $arrival = null, $documentScanned1 = null, $documentScanned2 = null, $seriesNumber = null, $confirmationNumber = null, $paxInfo_Validated = null, $info_Transmitted = null, $physicalFlightID_1 = null)
    {
        $this
            ->setApisInfoIndex($apisInfoIndex)
            ->setRecordNumber($recordNumber)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setBirthDate($birthDate)
            ->setGender($gender)
            ->setCitizenship($citizenship)
            ->setResidenceCountry($residenceCountry)
            ->setHomeAddress($homeAddress)
            ->setHomeCity($homeCity)
            ->setHomeState($homeState)
            ->setHomePostal($homePostal)
            ->setDestinationAddress($destinationAddress)
            ->setDestinationCity($destinationCity)
            ->setDestinationState($destinationState)
            ->setDestinationPostal($destinationPostal)
            ->setDestinationCountry($destinationCountry)
            ->setEmbarkation($embarkation)
            ->setBirthCity($birthCity)
            ->setBirthState($birthState)
            ->setBirthCountry($birthCountry)
            ->setStatus($status)
            ->setDocumentType1($documentType1)
            ->setDocumentNumber($documentNumber)
            ->setIssueCountry1($issueCountry1)
            ->setExpirationDate1($expirationDate1)
            ->setDocumentType2($documentType2)
            ->setDocumentNumber2($documentNumber2)
            ->setIssueCountry2($issueCountry2)
            ->setExpirationDate2($expirationDate2)
            ->setResultCode($resultCode)
            ->setPhysicalFlightId($physicalFlightId)
            ->setActualDepartureDate($actualDepartureDate)
            ->setFlightNumber($flightNumber)
            ->setDebarkation($debarkation)
            ->setArrival($arrival)
            ->setDocumentScanned1($documentScanned1)
            ->setDocumentScanned2($documentScanned2)
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setPaxInfo_Validated($paxInfo_Validated)
            ->setInfo_Transmitted($info_Transmitted)
            ->setPhysicalFlightID_1($physicalFlightID_1);
    }
    /**
     * Get ApisInfoIndex value
     * @return int|null
     */
    public function getApisInfoIndex()
    {
        return $this->ApisInfoIndex;
    }
    /**
     * Set ApisInfoIndex value
     * @param int $apisInfoIndex
     * @return \StructType\ApisInformation
     */
    public function setApisInfoIndex($apisInfoIndex = null)
    {
        // validation for constraint: int
        if (!is_null($apisInfoIndex) && !(is_int($apisInfoIndex) || ctype_digit($apisInfoIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($apisInfoIndex, true), gettype($apisInfoIndex)), __LINE__);
        }
        $this->ApisInfoIndex = $apisInfoIndex;
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\ApisInformation
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ApisInformation
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ApisInformation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\ApisInformation
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\ApisInformation
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Enumerations_GenderTypes::valueIsValid()
     * @uses \EnumType\Enumerations_GenderTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\ApisInformation
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_GenderTypes::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_GenderTypes', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\Enumerations_GenderTypes::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Citizenship value
     * @return string|null
     */
    public function getCitizenship()
    {
        return $this->Citizenship;
    }
    /**
     * Set Citizenship value
     * @param string $citizenship
     * @return \StructType\ApisInformation
     */
    public function setCitizenship($citizenship = null)
    {
        // validation for constraint: string
        if (!is_null($citizenship) && !is_string($citizenship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenship, true), gettype($citizenship)), __LINE__);
        }
        $this->Citizenship = $citizenship;
        return $this;
    }
    /**
     * Get ResidenceCountry value
     * @return string|null
     */
    public function getResidenceCountry()
    {
        return $this->ResidenceCountry;
    }
    /**
     * Set ResidenceCountry value
     * @param string $residenceCountry
     * @return \StructType\ApisInformation
     */
    public function setResidenceCountry($residenceCountry = null)
    {
        // validation for constraint: string
        if (!is_null($residenceCountry) && !is_string($residenceCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenceCountry, true), gettype($residenceCountry)), __LINE__);
        }
        $this->ResidenceCountry = $residenceCountry;
        return $this;
    }
    /**
     * Get HomeAddress value
     * @return string|null
     */
    public function getHomeAddress()
    {
        return $this->HomeAddress;
    }
    /**
     * Set HomeAddress value
     * @param string $homeAddress
     * @return \StructType\ApisInformation
     */
    public function setHomeAddress($homeAddress = null)
    {
        // validation for constraint: string
        if (!is_null($homeAddress) && !is_string($homeAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeAddress, true), gettype($homeAddress)), __LINE__);
        }
        $this->HomeAddress = $homeAddress;
        return $this;
    }
    /**
     * Get HomeCity value
     * @return string|null
     */
    public function getHomeCity()
    {
        return $this->HomeCity;
    }
    /**
     * Set HomeCity value
     * @param string $homeCity
     * @return \StructType\ApisInformation
     */
    public function setHomeCity($homeCity = null)
    {
        // validation for constraint: string
        if (!is_null($homeCity) && !is_string($homeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCity, true), gettype($homeCity)), __LINE__);
        }
        $this->HomeCity = $homeCity;
        return $this;
    }
    /**
     * Get HomeState value
     * @return string|null
     */
    public function getHomeState()
    {
        return $this->HomeState;
    }
    /**
     * Set HomeState value
     * @param string $homeState
     * @return \StructType\ApisInformation
     */
    public function setHomeState($homeState = null)
    {
        // validation for constraint: string
        if (!is_null($homeState) && !is_string($homeState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeState, true), gettype($homeState)), __LINE__);
        }
        $this->HomeState = $homeState;
        return $this;
    }
    /**
     * Get HomePostal value
     * @return string|null
     */
    public function getHomePostal()
    {
        return $this->HomePostal;
    }
    /**
     * Set HomePostal value
     * @param string $homePostal
     * @return \StructType\ApisInformation
     */
    public function setHomePostal($homePostal = null)
    {
        // validation for constraint: string
        if (!is_null($homePostal) && !is_string($homePostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePostal, true), gettype($homePostal)), __LINE__);
        }
        $this->HomePostal = $homePostal;
        return $this;
    }
    /**
     * Get DestinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->DestinationAddress;
    }
    /**
     * Set DestinationAddress value
     * @param string $destinationAddress
     * @return \StructType\ApisInformation
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAddress, true), gettype($destinationAddress)), __LINE__);
        }
        $this->DestinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get DestinationCity value
     * @return string|null
     */
    public function getDestinationCity()
    {
        return $this->DestinationCity;
    }
    /**
     * Set DestinationCity value
     * @param string $destinationCity
     * @return \StructType\ApisInformation
     */
    public function setDestinationCity($destinationCity = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCity) && !is_string($destinationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCity, true), gettype($destinationCity)), __LINE__);
        }
        $this->DestinationCity = $destinationCity;
        return $this;
    }
    /**
     * Get DestinationState value
     * @return string|null
     */
    public function getDestinationState()
    {
        return $this->DestinationState;
    }
    /**
     * Set DestinationState value
     * @param string $destinationState
     * @return \StructType\ApisInformation
     */
    public function setDestinationState($destinationState = null)
    {
        // validation for constraint: string
        if (!is_null($destinationState) && !is_string($destinationState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationState, true), gettype($destinationState)), __LINE__);
        }
        $this->DestinationState = $destinationState;
        return $this;
    }
    /**
     * Get DestinationPostal value
     * @return string|null
     */
    public function getDestinationPostal()
    {
        return $this->DestinationPostal;
    }
    /**
     * Set DestinationPostal value
     * @param string $destinationPostal
     * @return \StructType\ApisInformation
     */
    public function setDestinationPostal($destinationPostal = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPostal) && !is_string($destinationPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPostal, true), gettype($destinationPostal)), __LINE__);
        }
        $this->DestinationPostal = $destinationPostal;
        return $this;
    }
    /**
     * Get DestinationCountry value
     * @return string|null
     */
    public function getDestinationCountry()
    {
        return $this->DestinationCountry;
    }
    /**
     * Set DestinationCountry value
     * @param string $destinationCountry
     * @return \StructType\ApisInformation
     */
    public function setDestinationCountry($destinationCountry = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountry) && !is_string($destinationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCountry, true), gettype($destinationCountry)), __LINE__);
        }
        $this->DestinationCountry = $destinationCountry;
        return $this;
    }
    /**
     * Get Embarkation value
     * @return string|null
     */
    public function getEmbarkation()
    {
        return $this->Embarkation;
    }
    /**
     * Set Embarkation value
     * @param string $embarkation
     * @return \StructType\ApisInformation
     */
    public function setEmbarkation($embarkation = null)
    {
        // validation for constraint: string
        if (!is_null($embarkation) && !is_string($embarkation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($embarkation, true), gettype($embarkation)), __LINE__);
        }
        $this->Embarkation = $embarkation;
        return $this;
    }
    /**
     * Get BirthCity value
     * @return string|null
     */
    public function getBirthCity()
    {
        return $this->BirthCity;
    }
    /**
     * Set BirthCity value
     * @param string $birthCity
     * @return \StructType\ApisInformation
     */
    public function setBirthCity($birthCity = null)
    {
        // validation for constraint: string
        if (!is_null($birthCity) && !is_string($birthCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthCity, true), gettype($birthCity)), __LINE__);
        }
        $this->BirthCity = $birthCity;
        return $this;
    }
    /**
     * Get BirthState value
     * @return string|null
     */
    public function getBirthState()
    {
        return $this->BirthState;
    }
    /**
     * Set BirthState value
     * @param string $birthState
     * @return \StructType\ApisInformation
     */
    public function setBirthState($birthState = null)
    {
        // validation for constraint: string
        if (!is_null($birthState) && !is_string($birthState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthState, true), gettype($birthState)), __LINE__);
        }
        $this->BirthState = $birthState;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \StructType\ApisInformation
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthCountry, true), gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\ApisInformation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get DocumentType1 value
     * @return int|null
     */
    public function getDocumentType1()
    {
        return $this->DocumentType1;
    }
    /**
     * Set DocumentType1 value
     * @param int $documentType1
     * @return \StructType\ApisInformation
     */
    public function setDocumentType1($documentType1 = null)
    {
        // validation for constraint: int
        if (!is_null($documentType1) && !(is_int($documentType1) || ctype_digit($documentType1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentType1, true), gettype($documentType1)), __LINE__);
        }
        $this->DocumentType1 = $documentType1;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \StructType\ApisInformation
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get IssueCountry1 value
     * @return string|null
     */
    public function getIssueCountry1()
    {
        return $this->IssueCountry1;
    }
    /**
     * Set IssueCountry1 value
     * @param string $issueCountry1
     * @return \StructType\ApisInformation
     */
    public function setIssueCountry1($issueCountry1 = null)
    {
        // validation for constraint: string
        if (!is_null($issueCountry1) && !is_string($issueCountry1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueCountry1, true), gettype($issueCountry1)), __LINE__);
        }
        $this->IssueCountry1 = $issueCountry1;
        return $this;
    }
    /**
     * Get ExpirationDate1 value
     * @return string|null
     */
    public function getExpirationDate1()
    {
        return $this->ExpirationDate1;
    }
    /**
     * Set ExpirationDate1 value
     * @param string $expirationDate1
     * @return \StructType\ApisInformation
     */
    public function setExpirationDate1($expirationDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate1) && !is_string($expirationDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate1, true), gettype($expirationDate1)), __LINE__);
        }
        $this->ExpirationDate1 = $expirationDate1;
        return $this;
    }
    /**
     * Get DocumentType2 value
     * @return int|null
     */
    public function getDocumentType2()
    {
        return $this->DocumentType2;
    }
    /**
     * Set DocumentType2 value
     * @param int $documentType2
     * @return \StructType\ApisInformation
     */
    public function setDocumentType2($documentType2 = null)
    {
        // validation for constraint: int
        if (!is_null($documentType2) && !(is_int($documentType2) || ctype_digit($documentType2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentType2, true), gettype($documentType2)), __LINE__);
        }
        $this->DocumentType2 = $documentType2;
        return $this;
    }
    /**
     * Get DocumentNumber2 value
     * @return string|null
     */
    public function getDocumentNumber2()
    {
        return $this->DocumentNumber2;
    }
    /**
     * Set DocumentNumber2 value
     * @param string $documentNumber2
     * @return \StructType\ApisInformation
     */
    public function setDocumentNumber2($documentNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber2) && !is_string($documentNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber2, true), gettype($documentNumber2)), __LINE__);
        }
        $this->DocumentNumber2 = $documentNumber2;
        return $this;
    }
    /**
     * Get IssueCountry2 value
     * @return string|null
     */
    public function getIssueCountry2()
    {
        return $this->IssueCountry2;
    }
    /**
     * Set IssueCountry2 value
     * @param string $issueCountry2
     * @return \StructType\ApisInformation
     */
    public function setIssueCountry2($issueCountry2 = null)
    {
        // validation for constraint: string
        if (!is_null($issueCountry2) && !is_string($issueCountry2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueCountry2, true), gettype($issueCountry2)), __LINE__);
        }
        $this->IssueCountry2 = $issueCountry2;
        return $this;
    }
    /**
     * Get ExpirationDate2 value
     * @return string|null
     */
    public function getExpirationDate2()
    {
        return $this->ExpirationDate2;
    }
    /**
     * Set ExpirationDate2 value
     * @param string $expirationDate2
     * @return \StructType\ApisInformation
     */
    public function setExpirationDate2($expirationDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate2) && !is_string($expirationDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate2, true), gettype($expirationDate2)), __LINE__);
        }
        $this->ExpirationDate2 = $expirationDate2;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\ApisInformation
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !(is_int($resultCode) || ctype_digit($resultCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get PhysicalFlightId value
     * @return string|null
     */
    public function getPhysicalFlightId()
    {
        return $this->PhysicalFlightId;
    }
    /**
     * Set PhysicalFlightId value
     * @param string $physicalFlightId
     * @return \StructType\ApisInformation
     */
    public function setPhysicalFlightId($physicalFlightId = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFlightId) && !is_string($physicalFlightId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFlightId, true), gettype($physicalFlightId)), __LINE__);
        }
        $this->PhysicalFlightId = $physicalFlightId;
        return $this;
    }
    /**
     * Get ActualDepartureDate value
     * @return string|null
     */
    public function getActualDepartureDate()
    {
        return $this->ActualDepartureDate;
    }
    /**
     * Set ActualDepartureDate value
     * @param string $actualDepartureDate
     * @return \StructType\ApisInformation
     */
    public function setActualDepartureDate($actualDepartureDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepartureDate) && !is_string($actualDepartureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDepartureDate, true), gettype($actualDepartureDate)), __LINE__);
        }
        $this->ActualDepartureDate = $actualDepartureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\ApisInformation
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Debarkation value
     * @return string|null
     */
    public function getDebarkation()
    {
        return $this->Debarkation;
    }
    /**
     * Set Debarkation value
     * @param string $debarkation
     * @return \StructType\ApisInformation
     */
    public function setDebarkation($debarkation = null)
    {
        // validation for constraint: string
        if (!is_null($debarkation) && !is_string($debarkation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debarkation, true), gettype($debarkation)), __LINE__);
        }
        $this->Debarkation = $debarkation;
        return $this;
    }
    /**
     * Get Arrival value
     * @return string|null
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param string $arrival
     * @return \StructType\ApisInformation
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get DocumentScanned1 value
     * @return int|null
     */
    public function getDocumentScanned1()
    {
        return $this->DocumentScanned1;
    }
    /**
     * Set DocumentScanned1 value
     * @param int $documentScanned1
     * @return \StructType\ApisInformation
     */
    public function setDocumentScanned1($documentScanned1 = null)
    {
        // validation for constraint: int
        if (!is_null($documentScanned1) && !(is_int($documentScanned1) || ctype_digit($documentScanned1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentScanned1, true), gettype($documentScanned1)), __LINE__);
        }
        $this->DocumentScanned1 = $documentScanned1;
        return $this;
    }
    /**
     * Get DocumentScanned2 value
     * @return int|null
     */
    public function getDocumentScanned2()
    {
        return $this->DocumentScanned2;
    }
    /**
     * Set DocumentScanned2 value
     * @param int $documentScanned2
     * @return \StructType\ApisInformation
     */
    public function setDocumentScanned2($documentScanned2 = null)
    {
        // validation for constraint: int
        if (!is_null($documentScanned2) && !(is_int($documentScanned2) || ctype_digit($documentScanned2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentScanned2, true), gettype($documentScanned2)), __LINE__);
        }
        $this->DocumentScanned2 = $documentScanned2;
        return $this;
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ApisInformation
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ApisInformation
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get PaxInfo_Validated value
     * @return string|null
     */
    public function getPaxInfo_Validated()
    {
        return $this->PaxInfo_Validated;
    }
    /**
     * Set PaxInfo_Validated value
     * @param string $paxInfo_Validated
     * @return \StructType\ApisInformation
     */
    public function setPaxInfo_Validated($paxInfo_Validated = null)
    {
        // validation for constraint: string
        if (!is_null($paxInfo_Validated) && !is_string($paxInfo_Validated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxInfo_Validated, true), gettype($paxInfo_Validated)), __LINE__);
        }
        $this->PaxInfo_Validated = $paxInfo_Validated;
        return $this;
    }
    /**
     * Get Info_Transmitted value
     * @return string|null
     */
    public function getInfo_Transmitted()
    {
        return $this->Info_Transmitted;
    }
    /**
     * Set Info_Transmitted value
     * @param string $info_Transmitted
     * @return \StructType\ApisInformation
     */
    public function setInfo_Transmitted($info_Transmitted = null)
    {
        // validation for constraint: string
        if (!is_null($info_Transmitted) && !is_string($info_Transmitted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info_Transmitted, true), gettype($info_Transmitted)), __LINE__);
        }
        $this->Info_Transmitted = $info_Transmitted;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return string|null
     */
    public function getPhysicalFlightID_1()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param string $physicalFlightID
     * @return \StructType\ApisInformation
     */
    public function setPhysicalFlightID_1($physicalFlightID_1 = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFlightID_1) && !is_string($physicalFlightID_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFlightID_1, true), gettype($physicalFlightID_1)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID_1;
        return $this;
    }
}
