<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddTaxDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddTaxDetail
 * @subpackage Structs
 */
class AddTaxDetail extends OverrideChargeBase
{
    /**
     * The TaxID
     * @var int
     */
    public $TaxID;
    /**
     * Constructor method for AddTaxDetail
     * @uses AddTaxDetail::setTaxID()
     * @param int $taxID
     */
    public function __construct($taxID = null)
    {
        $this
            ->setTaxID($taxID);
    }
    /**
     * Get TaxID value
     * @return int|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param int $taxID
     * @return \StructType\AddTaxDetail
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: int
        if (!is_null($taxID) && !(is_int($taxID) || ctype_digit($taxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
}
