<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPerson ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPerson
 * @subpackage Arrays
 */
class ArrayOfPerson extends AbstractStructArrayBase
{
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person[]
     */
    public $Person;
    /**
     * Constructor method for ArrayOfPerson
     * @uses ArrayOfPerson::setPerson()
     * @param \StructType\Person[] $person
     */
    public function __construct(array $person = array())
    {
        $this
            ->setPerson($person);
    }
    /**
     * Get Person value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person[]|null
     */
    public function getPerson()
    {
        return isset($this->Person) ? $this->Person : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonForArrayConstraintsFromSetPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonPersonItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonPersonItem instanceof \StructType\Person) {
                $invalidValues[] = is_object($arrayOfPersonPersonItem) ? get_class($arrayOfPersonPersonItem) : sprintf('%s(%s)', gettype($arrayOfPersonPersonItem), var_export($arrayOfPersonPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Person value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Person[] $person
     * @return \ArrayType\ArrayOfPerson
     */
    public function setPerson(array $person = array())
    {
        // validation for constraint: array
        if ('' !== ($personArrayErrorMessage = self::validatePersonForArrayConstraintsFromSetPerson($person))) {
            throw new \InvalidArgumentException($personArrayErrorMessage, __LINE__);
        }
        if (is_null($person) || (is_array($person) && empty($person))) {
            unset($this->Person);
        } else {
            $this->Person = $person;
        }
        return $this;
    }
    /**
     * Add item to Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person $item
     * @return \ArrayType\ArrayOfPerson
     */
    public function addToPerson(\StructType\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person) {
            throw new \InvalidArgumentException(sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Person[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Person|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Person|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Person|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Person|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Person|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Person
     */
    public function getAttributeName()
    {
        return 'Person';
    }
}
