<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewPNRModificationImpact StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewPNRModificationImpact
 * @subpackage Structs
 */
class ViewPNRModificationImpact extends AbstractStructBase
{
    /**
     * The RefundType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The RefundAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RefundAmount;
    /**
     * The RefundCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundCurrency;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ChargeKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChargeKey;
    /**
     * The ChargeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChargeCode;
    /**
     * The PaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentID;
    /**
     * The RefundTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundTo;
    /**
     * Constructor method for ViewPNRModificationImpact
     * @uses ViewPNRModificationImpact::setRefundType()
     * @uses ViewPNRModificationImpact::setAmount()
     * @uses ViewPNRModificationImpact::setCurrency()
     * @uses ViewPNRModificationImpact::setRefundAmount()
     * @uses ViewPNRModificationImpact::setRefundCurrency()
     * @uses ViewPNRModificationImpact::setExchangeRate()
     * @uses ViewPNRModificationImpact::setChargeKey()
     * @uses ViewPNRModificationImpact::setChargeCode()
     * @uses ViewPNRModificationImpact::setPaymentID()
     * @uses ViewPNRModificationImpact::setRefundTo()
     * @param string $refundType
     * @param float $amount
     * @param string $currency
     * @param float $refundAmount
     * @param string $refundCurrency
     * @param float $exchangeRate
     * @param string $chargeKey
     * @param string $chargeCode
     * @param string $paymentID
     * @param string $refundTo
     */
    public function __construct($refundType = null, $amount = null, $currency = null, $refundAmount = null, $refundCurrency = null, $exchangeRate = null, $chargeKey = null, $chargeCode = null, $paymentID = null, $refundTo = null)
    {
        $this
            ->setRefundType($refundType)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setRefundAmount($refundAmount)
            ->setRefundCurrency($refundCurrency)
            ->setExchangeRate($exchangeRate)
            ->setChargeKey($chargeKey)
            ->setChargeCode($chargeCode)
            ->setPaymentID($paymentID)
            ->setRefundTo($refundTo);
    }
    /**
     * Get RefundType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundType()
    {
        return isset($this->RefundType) ? $this->RefundType : null;
    }
    /**
     * Set RefundType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundType
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setRefundType($refundType = null)
    {
        // validation for constraint: string
        if (!is_null($refundType) && !is_string($refundType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundType, true), gettype($refundType)), __LINE__);
        }
        if (is_null($refundType) || (is_array($refundType) && empty($refundType))) {
            unset($this->RefundType);
        } else {
            $this->RefundType = $refundType;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return float|null
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param float $refundAmount
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setRefundAmount($refundAmount = null)
    {
        // validation for constraint: float
        if (!is_null($refundAmount) && !(is_float($refundAmount) || is_numeric($refundAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundAmount, true), gettype($refundAmount)), __LINE__);
        }
        $this->RefundAmount = $refundAmount;
        return $this;
    }
    /**
     * Get RefundCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundCurrency()
    {
        return isset($this->RefundCurrency) ? $this->RefundCurrency : null;
    }
    /**
     * Set RefundCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundCurrency
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setRefundCurrency($refundCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($refundCurrency) && !is_string($refundCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundCurrency, true), gettype($refundCurrency)), __LINE__);
        }
        if (is_null($refundCurrency) || (is_array($refundCurrency) && empty($refundCurrency))) {
            unset($this->RefundCurrency);
        } else {
            $this->RefundCurrency = $refundCurrency;
        }
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ChargeKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChargeKey()
    {
        return isset($this->ChargeKey) ? $this->ChargeKey : null;
    }
    /**
     * Set ChargeKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chargeKey
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setChargeKey($chargeKey = null)
    {
        // validation for constraint: string
        if (!is_null($chargeKey) && !is_string($chargeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeKey, true), gettype($chargeKey)), __LINE__);
        }
        if (is_null($chargeKey) || (is_array($chargeKey) && empty($chargeKey))) {
            unset($this->ChargeKey);
        } else {
            $this->ChargeKey = $chargeKey;
        }
        return $this;
    }
    /**
     * Get ChargeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChargeCode()
    {
        return isset($this->ChargeCode) ? $this->ChargeCode : null;
    }
    /**
     * Set ChargeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chargeCode
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCode, true), gettype($chargeCode)), __LINE__);
        }
        if (is_null($chargeCode) || (is_array($chargeCode) && empty($chargeCode))) {
            unset($this->ChargeCode);
        } else {
            $this->ChargeCode = $chargeCode;
        }
        return $this;
    }
    /**
     * Get PaymentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentID()
    {
        return isset($this->PaymentID) ? $this->PaymentID : null;
    }
    /**
     * Set PaymentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentID
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentID) && !is_string($paymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentID, true), gettype($paymentID)), __LINE__);
        }
        if (is_null($paymentID) || (is_array($paymentID) && empty($paymentID))) {
            unset($this->PaymentID);
        } else {
            $this->PaymentID = $paymentID;
        }
        return $this;
    }
    /**
     * Get RefundTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundTo()
    {
        return isset($this->RefundTo) ? $this->RefundTo : null;
    }
    /**
     * Set RefundTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundTo
     * @return \StructType\ViewPNRModificationImpact
     */
    public function setRefundTo($refundTo = null)
    {
        // validation for constraint: string
        if (!is_null($refundTo) && !is_string($refundTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundTo, true), gettype($refundTo)), __LINE__);
        }
        if (is_null($refundTo) || (is_array($refundTo) && empty($refundTo))) {
            unset($this->RefundTo);
        } else {
            $this->RefundTo = $refundTo;
        }
        return $this;
    }
}
