<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveApisInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveApisInfo
 * @subpackage Structs
 */
class RetrieveApisInfo extends TransactionInfo
{
    /**
     * The RetrieveApisInfoRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveApisInfo
     */
    public $RetrieveApisInfoRequest;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The OmitCancelled
     * @var bool
     */
    public $OmitCancelled;
    /**
     * Constructor method for RetrieveApisInfo
     * @uses RetrieveApisInfo::setRetrieveApisInfoRequest()
     * @uses RetrieveApisInfo::setSeriesNumber()
     * @uses RetrieveApisInfo::setConfirmationNumber()
     * @uses RetrieveApisInfo::setOmitCancelled()
     * @param \StructType\RetrieveApisInfo $retrieveApisInfoRequest
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param bool $omitCancelled
     */
    public function __construct(\StructType\RetrieveApisInfo $retrieveApisInfoRequest = null, $seriesNumber = null, $confirmationNumber = null, $omitCancelled = null)
    {
        $this
            ->setRetrieveApisInfoRequest($retrieveApisInfoRequest)
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setOmitCancelled($omitCancelled);
    }
    /**
     * Get RetrieveApisInfoRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveApisInfo|null
     */
    public function getRetrieveApisInfoRequest()
    {
        return isset($this->RetrieveApisInfoRequest) ? $this->RetrieveApisInfoRequest : null;
    }
    /**
     * Set RetrieveApisInfoRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveApisInfo $retrieveApisInfoRequest
     * @return \StructType\RetrieveApisInfo
     */
    public function setRetrieveApisInfoRequest(\StructType\RetrieveApisInfo $retrieveApisInfoRequest = null)
    {
        if (is_null($retrieveApisInfoRequest) || (is_array($retrieveApisInfoRequest) && empty($retrieveApisInfoRequest))) {
            unset($this->RetrieveApisInfoRequest);
        } else {
            $this->RetrieveApisInfoRequest = $retrieveApisInfoRequest;
        }
        return $this;
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\RetrieveApisInfo
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\RetrieveApisInfo
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get OmitCancelled value
     * @return bool|null
     */
    public function getOmitCancelled()
    {
        return $this->OmitCancelled;
    }
    /**
     * Set OmitCancelled value
     * @param bool $omitCancelled
     * @return \StructType\RetrieveApisInfo
     */
    public function setOmitCancelled($omitCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($omitCancelled) && !is_bool($omitCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($omitCancelled, true), gettype($omitCancelled)), __LINE__);
        }
        $this->OmitCancelled = $omitCancelled;
        return $this;
    }
}
