<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessFlightDisruptionAlert StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcessFlightDisruptionAlert
 * @subpackage Structs
 */
class ProcessFlightDisruptionAlert extends TransactionInfo
{
    /**
     * The ProcessFlightDisruptionAlertRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProcessFlightDisruptionAlert
     */
    public $ProcessFlightDisruptionAlertRequest;
    /**
     * The LogicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKey;
    /**
     * The UserResponse
     * @var string
     */
    public $UserResponse;
    /**
     * Constructor method for ProcessFlightDisruptionAlert
     * @uses ProcessFlightDisruptionAlert::setProcessFlightDisruptionAlertRequest()
     * @uses ProcessFlightDisruptionAlert::setLogicalFlightKey()
     * @uses ProcessFlightDisruptionAlert::setUserResponse()
     * @param \StructType\ProcessFlightDisruptionAlert $processFlightDisruptionAlertRequest
     * @param string $logicalFlightKey
     * @param string $userResponse
     */
    public function __construct(\StructType\ProcessFlightDisruptionAlert $processFlightDisruptionAlertRequest = null, $logicalFlightKey = null, $userResponse = null)
    {
        $this
            ->setProcessFlightDisruptionAlertRequest($processFlightDisruptionAlertRequest)
            ->setLogicalFlightKey($logicalFlightKey)
            ->setUserResponse($userResponse);
    }
    /**
     * Get ProcessFlightDisruptionAlertRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProcessFlightDisruptionAlert|null
     */
    public function getProcessFlightDisruptionAlertRequest()
    {
        return isset($this->ProcessFlightDisruptionAlertRequest) ? $this->ProcessFlightDisruptionAlertRequest : null;
    }
    /**
     * Set ProcessFlightDisruptionAlertRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProcessFlightDisruptionAlert $processFlightDisruptionAlertRequest
     * @return \StructType\ProcessFlightDisruptionAlert
     */
    public function setProcessFlightDisruptionAlertRequest(\StructType\ProcessFlightDisruptionAlert $processFlightDisruptionAlertRequest = null)
    {
        if (is_null($processFlightDisruptionAlertRequest) || (is_array($processFlightDisruptionAlertRequest) && empty($processFlightDisruptionAlertRequest))) {
            unset($this->ProcessFlightDisruptionAlertRequest);
        } else {
            $this->ProcessFlightDisruptionAlertRequest = $processFlightDisruptionAlertRequest;
        }
        return $this;
    }
    /**
     * Get LogicalFlightKey value
     * @return string|null
     */
    public function getLogicalFlightKey()
    {
        return $this->LogicalFlightKey;
    }
    /**
     * Set LogicalFlightKey value
     * @param string $logicalFlightKey
     * @return \StructType\ProcessFlightDisruptionAlert
     */
    public function setLogicalFlightKey($logicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKey) && !is_string($logicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKey, true), gettype($logicalFlightKey)), __LINE__);
        }
        $this->LogicalFlightKey = $logicalFlightKey;
        return $this;
    }
    /**
     * Get UserResponse value
     * @return string|null
     */
    public function getUserResponse()
    {
        return $this->UserResponse;
    }
    /**
     * Set UserResponse value
     * @uses \EnumType\ProcessFlightDisruptionAlert_UserResponseType::valueIsValid()
     * @uses \EnumType\ProcessFlightDisruptionAlert_UserResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userResponse
     * @return \StructType\ProcessFlightDisruptionAlert
     */
    public function setUserResponse($userResponse = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProcessFlightDisruptionAlert_UserResponseType::valueIsValid($userResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProcessFlightDisruptionAlert_UserResponseType', is_array($userResponse) ? implode(', ', $userResponse) : var_export($userResponse, true), implode(', ', \EnumType\ProcessFlightDisruptionAlert_UserResponseType::getValidValues())), __LINE__);
        }
        $this->UserResponse = $userResponse;
        return $this;
    }
}
