<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR.UpdatePassenger StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR.UpdatePassenger
 * @subpackage Structs
 */
class ModifyPNR_UpdatePassenger extends ModifyPNR_Person
{
    /**
     * The RedressNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RedressNumber;
    /**
     * The KnownTravelerNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $KnownTravelerNumber;
    /**
     * The FrequentFlyerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * Constructor method for ModifyPNR.UpdatePassenger
     * @uses ModifyPNR_UpdatePassenger::setRedressNumber()
     * @uses ModifyPNR_UpdatePassenger::setKnownTravelerNumber()
     * @uses ModifyPNR_UpdatePassenger::setFrequentFlyerNumber()
     * @param string $redressNumber
     * @param string $knownTravelerNumber
     * @param string $frequentFlyerNumber
     */
    public function __construct($redressNumber = null, $knownTravelerNumber = null, $frequentFlyerNumber = null)
    {
        $this
            ->setRedressNumber($redressNumber)
            ->setKnownTravelerNumber($knownTravelerNumber)
            ->setFrequentFlyerNumber($frequentFlyerNumber);
    }
    /**
     * Get RedressNumber value
     * @return string|null
     */
    public function getRedressNumber()
    {
        return $this->RedressNumber;
    }
    /**
     * Set RedressNumber value
     * @param string $redressNumber
     * @return \StructType\ModifyPNR_UpdatePassenger
     */
    public function setRedressNumber($redressNumber = null)
    {
        // validation for constraint: string
        if (!is_null($redressNumber) && !is_string($redressNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redressNumber, true), gettype($redressNumber)), __LINE__);
        }
        $this->RedressNumber = $redressNumber;
        return $this;
    }
    /**
     * Get KnownTravelerNumber value
     * @return string|null
     */
    public function getKnownTravelerNumber()
    {
        return $this->KnownTravelerNumber;
    }
    /**
     * Set KnownTravelerNumber value
     * @param string $knownTravelerNumber
     * @return \StructType\ModifyPNR_UpdatePassenger
     */
    public function setKnownTravelerNumber($knownTravelerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($knownTravelerNumber) && !is_string($knownTravelerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knownTravelerNumber, true), gettype($knownTravelerNumber)), __LINE__);
        }
        $this->KnownTravelerNumber = $knownTravelerNumber;
        return $this;
    }
    /**
     * Get FrequentFlyerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return isset($this->FrequentFlyerNumber) ? $this->FrequentFlyerNumber : null;
    }
    /**
     * Set FrequentFlyerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerNumber
     * @return \StructType\ModifyPNR_UpdatePassenger
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumber) && !is_string($frequentFlyerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerNumber, true), gettype($frequentFlyerNumber)), __LINE__);
        }
        if (is_null($frequentFlyerNumber) || (is_array($frequentFlyerNumber) && empty($frequentFlyerNumber))) {
            unset($this->FrequentFlyerNumber);
        } else {
            $this->FrequentFlyerNumber = $frequentFlyerNumber;
        }
        return $this;
    }
}
