<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR
 * @subpackage Structs
 */
class ModifyPNR extends TransactionInfo
{
    /**
     * The ModifyPnrRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ModifyPNR
     */
    public $ModifyPnrRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The FareInformationID
     * @var int
     */
    public $FareInformationID;
    /**
     * The LogicalFlightKeyToReplace
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKeyToReplace;
    /**
     * The LogicalFlightKeyToRemove
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKeyToRemove;
    /**
     * The PersonOrgIdentifierToRemove
     * @var int
     */
    public $PersonOrgIdentifierToRemove;
    /**
     * The PassengersToAdd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_Passenger
     */
    public $PassengersToAdd;
    /**
     * The PassengersToUpdate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_UpdatePassenger
     */
    public $PassengersToUpdate;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * The SpecialServicesToCancel
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialServiceToCancel
     */
    public $SpecialServicesToCancel;
    /**
     * The ContactInformationToAdd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_AddContactInfo
     */
    public $ContactInformationToAdd;
    /**
     * The ContactInformationToUpdate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_UpdateContactInfo
     */
    public $ContactInformationToUpdate;
    /**
     * The CommentToAdd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Comment
     */
    public $CommentToAdd;
    /**
     * The EmergencyContactsToAddToSegments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_EmergencyContact
     */
    public $EmergencyContactsToAddToSegments;
    /**
     * The PassengerGroupingsToUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_UpdatePassengerGrouping
     */
    public $PassengerGroupingsToUpdate;
    /**
     * The PassengerSegmentsToUpdateRecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_UpdateRecordLocator
     */
    public $PassengerSegmentsToUpdateRecordLocator;
    /**
     * The UpdateTravelsWithPassenger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_UpdateTravelsWithPersonOrg
     */
    public $UpdateTravelsWithPassenger;
    /**
     * The IsFlightDisruptionModify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFlightDisruptionModify;
    /**
     * The LogicalFlightKeysToReplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $LogicalFlightKeysToReplace;
    /**
     * Constructor method for ModifyPNR
     * @uses ModifyPNR::setModifyPnrRequest()
     * @uses ModifyPNR::setActionType()
     * @uses ModifyPNR::setReservationInfo()
     * @uses ModifyPNR::setFareInformationID()
     * @uses ModifyPNR::setLogicalFlightKeyToReplace()
     * @uses ModifyPNR::setLogicalFlightKeyToRemove()
     * @uses ModifyPNR::setPersonOrgIdentifierToRemove()
     * @uses ModifyPNR::setPassengersToAdd()
     * @uses ModifyPNR::setPassengersToUpdate()
     * @uses ModifyPNR::setSpecialServices()
     * @uses ModifyPNR::setSpecialServicesToCancel()
     * @uses ModifyPNR::setContactInformationToAdd()
     * @uses ModifyPNR::setContactInformationToUpdate()
     * @uses ModifyPNR::setCommentToAdd()
     * @uses ModifyPNR::setEmergencyContactsToAddToSegments()
     * @uses ModifyPNR::setPassengerGroupingsToUpdate()
     * @uses ModifyPNR::setPassengerSegmentsToUpdateRecordLocator()
     * @uses ModifyPNR::setUpdateTravelsWithPassenger()
     * @uses ModifyPNR::setIsFlightDisruptionModify()
     * @uses ModifyPNR::setLogicalFlightKeysToReplace()
     * @param \StructType\ModifyPNR $modifyPnrRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param int $fareInformationID
     * @param string $logicalFlightKeyToReplace
     * @param string $logicalFlightKeyToRemove
     * @param int $personOrgIdentifierToRemove
     * @param \ArrayType\ArrayOfModifyPNR_Passenger $passengersToAdd
     * @param \ArrayType\ArrayOfModifyPNR_UpdatePassenger $passengersToUpdate
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @param \ArrayType\ArrayOfSpecialServiceToCancel $specialServicesToCancel
     * @param \ArrayType\ArrayOfModifyPNR_AddContactInfo $contactInformationToAdd
     * @param \ArrayType\ArrayOfModifyPNR_UpdateContactInfo $contactInformationToUpdate
     * @param \StructType\Comment $commentToAdd
     * @param \ArrayType\ArrayOfModifyPNR_EmergencyContact $emergencyContactsToAddToSegments
     * @param \ArrayType\ArrayOfModifyPNR_UpdatePassengerGrouping $passengerGroupingsToUpdate
     * @param \ArrayType\ArrayOfModifyPNR_UpdateRecordLocator $passengerSegmentsToUpdateRecordLocator
     * @param \ArrayType\ArrayOfModifyPNR_UpdateTravelsWithPersonOrg $updateTravelsWithPassenger
     * @param bool $isFlightDisruptionModify
     * @param \ArrayType\ArrayOfstring $logicalFlightKeysToReplace
     */
    public function __construct(\StructType\ModifyPNR $modifyPnrRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, $fareInformationID = null, $logicalFlightKeyToReplace = null, $logicalFlightKeyToRemove = null, $personOrgIdentifierToRemove = null, \ArrayType\ArrayOfModifyPNR_Passenger $passengersToAdd = null, \ArrayType\ArrayOfModifyPNR_UpdatePassenger $passengersToUpdate = null, \ArrayType\ArrayOfSpecialService $specialServices = null, \ArrayType\ArrayOfSpecialServiceToCancel $specialServicesToCancel = null, \ArrayType\ArrayOfModifyPNR_AddContactInfo $contactInformationToAdd = null, \ArrayType\ArrayOfModifyPNR_UpdateContactInfo $contactInformationToUpdate = null, \StructType\Comment $commentToAdd = null, \ArrayType\ArrayOfModifyPNR_EmergencyContact $emergencyContactsToAddToSegments = null, \ArrayType\ArrayOfModifyPNR_UpdatePassengerGrouping $passengerGroupingsToUpdate = null, \ArrayType\ArrayOfModifyPNR_UpdateRecordLocator $passengerSegmentsToUpdateRecordLocator = null, \ArrayType\ArrayOfModifyPNR_UpdateTravelsWithPersonOrg $updateTravelsWithPassenger = null, $isFlightDisruptionModify = null, \ArrayType\ArrayOfstring $logicalFlightKeysToReplace = null)
    {
        $this
            ->setModifyPnrRequest($modifyPnrRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setFareInformationID($fareInformationID)
            ->setLogicalFlightKeyToReplace($logicalFlightKeyToReplace)
            ->setLogicalFlightKeyToRemove($logicalFlightKeyToRemove)
            ->setPersonOrgIdentifierToRemove($personOrgIdentifierToRemove)
            ->setPassengersToAdd($passengersToAdd)
            ->setPassengersToUpdate($passengersToUpdate)
            ->setSpecialServices($specialServices)
            ->setSpecialServicesToCancel($specialServicesToCancel)
            ->setContactInformationToAdd($contactInformationToAdd)
            ->setContactInformationToUpdate($contactInformationToUpdate)
            ->setCommentToAdd($commentToAdd)
            ->setEmergencyContactsToAddToSegments($emergencyContactsToAddToSegments)
            ->setPassengerGroupingsToUpdate($passengerGroupingsToUpdate)
            ->setPassengerSegmentsToUpdateRecordLocator($passengerSegmentsToUpdateRecordLocator)
            ->setUpdateTravelsWithPassenger($updateTravelsWithPassenger)
            ->setIsFlightDisruptionModify($isFlightDisruptionModify)
            ->setLogicalFlightKeysToReplace($logicalFlightKeysToReplace);
    }
    /**
     * Get ModifyPnrRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ModifyPNR|null
     */
    public function getModifyPnrRequest()
    {
        return isset($this->ModifyPnrRequest) ? $this->ModifyPnrRequest : null;
    }
    /**
     * Set ModifyPnrRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ModifyPNR $modifyPnrRequest
     * @return \StructType\ModifyPNR
     */
    public function setModifyPnrRequest(\StructType\ModifyPNR $modifyPnrRequest = null)
    {
        if (is_null($modifyPnrRequest) || (is_array($modifyPnrRequest) && empty($modifyPnrRequest))) {
            unset($this->ModifyPnrRequest);
        } else {
            $this->ModifyPnrRequest = $modifyPnrRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ModifyPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\ModifyPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ModifyPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModifyPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ModifyPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\ModifyPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\ModifyPNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get FareInformationID value
     * @return int|null
     */
    public function getFareInformationID()
    {
        return $this->FareInformationID;
    }
    /**
     * Set FareInformationID value
     * @param int $fareInformationID
     * @return \StructType\ModifyPNR
     */
    public function setFareInformationID($fareInformationID = null)
    {
        // validation for constraint: int
        if (!is_null($fareInformationID) && !(is_int($fareInformationID) || ctype_digit($fareInformationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareInformationID, true), gettype($fareInformationID)), __LINE__);
        }
        $this->FareInformationID = $fareInformationID;
        return $this;
    }
    /**
     * Get LogicalFlightKeyToReplace value
     * @return string|null
     */
    public function getLogicalFlightKeyToReplace()
    {
        return $this->LogicalFlightKeyToReplace;
    }
    /**
     * Set LogicalFlightKeyToReplace value
     * @param string $logicalFlightKeyToReplace
     * @return \StructType\ModifyPNR
     */
    public function setLogicalFlightKeyToReplace($logicalFlightKeyToReplace = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKeyToReplace) && !is_string($logicalFlightKeyToReplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKeyToReplace, true), gettype($logicalFlightKeyToReplace)), __LINE__);
        }
        $this->LogicalFlightKeyToReplace = $logicalFlightKeyToReplace;
        return $this;
    }
    /**
     * Get LogicalFlightKeyToRemove value
     * @return string|null
     */
    public function getLogicalFlightKeyToRemove()
    {
        return $this->LogicalFlightKeyToRemove;
    }
    /**
     * Set LogicalFlightKeyToRemove value
     * @param string $logicalFlightKeyToRemove
     * @return \StructType\ModifyPNR
     */
    public function setLogicalFlightKeyToRemove($logicalFlightKeyToRemove = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKeyToRemove) && !is_string($logicalFlightKeyToRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKeyToRemove, true), gettype($logicalFlightKeyToRemove)), __LINE__);
        }
        $this->LogicalFlightKeyToRemove = $logicalFlightKeyToRemove;
        return $this;
    }
    /**
     * Get PersonOrgIdentifierToRemove value
     * @return int|null
     */
    public function getPersonOrgIdentifierToRemove()
    {
        return $this->PersonOrgIdentifierToRemove;
    }
    /**
     * Set PersonOrgIdentifierToRemove value
     * @param int $personOrgIdentifierToRemove
     * @return \StructType\ModifyPNR
     */
    public function setPersonOrgIdentifierToRemove($personOrgIdentifierToRemove = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgIdentifierToRemove) && !(is_int($personOrgIdentifierToRemove) || ctype_digit($personOrgIdentifierToRemove))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgIdentifierToRemove, true), gettype($personOrgIdentifierToRemove)), __LINE__);
        }
        $this->PersonOrgIdentifierToRemove = $personOrgIdentifierToRemove;
        return $this;
    }
    /**
     * Get PassengersToAdd value
     * @return \ArrayType\ArrayOfModifyPNR_Passenger|null
     */
    public function getPassengersToAdd()
    {
        return $this->PassengersToAdd;
    }
    /**
     * Set PassengersToAdd value
     * @param \ArrayType\ArrayOfModifyPNR_Passenger $passengersToAdd
     * @return \StructType\ModifyPNR
     */
    public function setPassengersToAdd(\ArrayType\ArrayOfModifyPNR_Passenger $passengersToAdd = null)
    {
        $this->PassengersToAdd = $passengersToAdd;
        return $this;
    }
    /**
     * Get PassengersToUpdate value
     * @return \ArrayType\ArrayOfModifyPNR_UpdatePassenger|null
     */
    public function getPassengersToUpdate()
    {
        return $this->PassengersToUpdate;
    }
    /**
     * Set PassengersToUpdate value
     * @param \ArrayType\ArrayOfModifyPNR_UpdatePassenger $passengersToUpdate
     * @return \StructType\ModifyPNR
     */
    public function setPassengersToUpdate(\ArrayType\ArrayOfModifyPNR_UpdatePassenger $passengersToUpdate = null)
    {
        $this->PassengersToUpdate = $passengersToUpdate;
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @return \StructType\ModifyPNR
     */
    public function setSpecialServices(\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Get SpecialServicesToCancel value
     * @return \ArrayType\ArrayOfSpecialServiceToCancel|null
     */
    public function getSpecialServicesToCancel()
    {
        return $this->SpecialServicesToCancel;
    }
    /**
     * Set SpecialServicesToCancel value
     * @param \ArrayType\ArrayOfSpecialServiceToCancel $specialServicesToCancel
     * @return \StructType\ModifyPNR
     */
    public function setSpecialServicesToCancel(\ArrayType\ArrayOfSpecialServiceToCancel $specialServicesToCancel = null)
    {
        $this->SpecialServicesToCancel = $specialServicesToCancel;
        return $this;
    }
    /**
     * Get ContactInformationToAdd value
     * @return \ArrayType\ArrayOfModifyPNR_AddContactInfo|null
     */
    public function getContactInformationToAdd()
    {
        return $this->ContactInformationToAdd;
    }
    /**
     * Set ContactInformationToAdd value
     * @param \ArrayType\ArrayOfModifyPNR_AddContactInfo $contactInformationToAdd
     * @return \StructType\ModifyPNR
     */
    public function setContactInformationToAdd(\ArrayType\ArrayOfModifyPNR_AddContactInfo $contactInformationToAdd = null)
    {
        $this->ContactInformationToAdd = $contactInformationToAdd;
        return $this;
    }
    /**
     * Get ContactInformationToUpdate value
     * @return \ArrayType\ArrayOfModifyPNR_UpdateContactInfo|null
     */
    public function getContactInformationToUpdate()
    {
        return $this->ContactInformationToUpdate;
    }
    /**
     * Set ContactInformationToUpdate value
     * @param \ArrayType\ArrayOfModifyPNR_UpdateContactInfo $contactInformationToUpdate
     * @return \StructType\ModifyPNR
     */
    public function setContactInformationToUpdate(\ArrayType\ArrayOfModifyPNR_UpdateContactInfo $contactInformationToUpdate = null)
    {
        $this->ContactInformationToUpdate = $contactInformationToUpdate;
        return $this;
    }
    /**
     * Get CommentToAdd value
     * @return \StructType\Comment|null
     */
    public function getCommentToAdd()
    {
        return $this->CommentToAdd;
    }
    /**
     * Set CommentToAdd value
     * @param \StructType\Comment $commentToAdd
     * @return \StructType\ModifyPNR
     */
    public function setCommentToAdd(\StructType\Comment $commentToAdd = null)
    {
        $this->CommentToAdd = $commentToAdd;
        return $this;
    }
    /**
     * Get EmergencyContactsToAddToSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfModifyPNR_EmergencyContact|null
     */
    public function getEmergencyContactsToAddToSegments()
    {
        return isset($this->EmergencyContactsToAddToSegments) ? $this->EmergencyContactsToAddToSegments : null;
    }
    /**
     * Set EmergencyContactsToAddToSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfModifyPNR_EmergencyContact $emergencyContactsToAddToSegments
     * @return \StructType\ModifyPNR
     */
    public function setEmergencyContactsToAddToSegments(\ArrayType\ArrayOfModifyPNR_EmergencyContact $emergencyContactsToAddToSegments = null)
    {
        if (is_null($emergencyContactsToAddToSegments) || (is_array($emergencyContactsToAddToSegments) && empty($emergencyContactsToAddToSegments))) {
            unset($this->EmergencyContactsToAddToSegments);
        } else {
            $this->EmergencyContactsToAddToSegments = $emergencyContactsToAddToSegments;
        }
        return $this;
    }
    /**
     * Get PassengerGroupingsToUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfModifyPNR_UpdatePassengerGrouping|null
     */
    public function getPassengerGroupingsToUpdate()
    {
        return isset($this->PassengerGroupingsToUpdate) ? $this->PassengerGroupingsToUpdate : null;
    }
    /**
     * Set PassengerGroupingsToUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfModifyPNR_UpdatePassengerGrouping $passengerGroupingsToUpdate
     * @return \StructType\ModifyPNR
     */
    public function setPassengerGroupingsToUpdate(\ArrayType\ArrayOfModifyPNR_UpdatePassengerGrouping $passengerGroupingsToUpdate = null)
    {
        if (is_null($passengerGroupingsToUpdate) || (is_array($passengerGroupingsToUpdate) && empty($passengerGroupingsToUpdate))) {
            unset($this->PassengerGroupingsToUpdate);
        } else {
            $this->PassengerGroupingsToUpdate = $passengerGroupingsToUpdate;
        }
        return $this;
    }
    /**
     * Get PassengerSegmentsToUpdateRecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfModifyPNR_UpdateRecordLocator|null
     */
    public function getPassengerSegmentsToUpdateRecordLocator()
    {
        return isset($this->PassengerSegmentsToUpdateRecordLocator) ? $this->PassengerSegmentsToUpdateRecordLocator : null;
    }
    /**
     * Set PassengerSegmentsToUpdateRecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfModifyPNR_UpdateRecordLocator $passengerSegmentsToUpdateRecordLocator
     * @return \StructType\ModifyPNR
     */
    public function setPassengerSegmentsToUpdateRecordLocator(\ArrayType\ArrayOfModifyPNR_UpdateRecordLocator $passengerSegmentsToUpdateRecordLocator = null)
    {
        if (is_null($passengerSegmentsToUpdateRecordLocator) || (is_array($passengerSegmentsToUpdateRecordLocator) && empty($passengerSegmentsToUpdateRecordLocator))) {
            unset($this->PassengerSegmentsToUpdateRecordLocator);
        } else {
            $this->PassengerSegmentsToUpdateRecordLocator = $passengerSegmentsToUpdateRecordLocator;
        }
        return $this;
    }
    /**
     * Get UpdateTravelsWithPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfModifyPNR_UpdateTravelsWithPersonOrg|null
     */
    public function getUpdateTravelsWithPassenger()
    {
        return isset($this->UpdateTravelsWithPassenger) ? $this->UpdateTravelsWithPassenger : null;
    }
    /**
     * Set UpdateTravelsWithPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfModifyPNR_UpdateTravelsWithPersonOrg $updateTravelsWithPassenger
     * @return \StructType\ModifyPNR
     */
    public function setUpdateTravelsWithPassenger(\ArrayType\ArrayOfModifyPNR_UpdateTravelsWithPersonOrg $updateTravelsWithPassenger = null)
    {
        if (is_null($updateTravelsWithPassenger) || (is_array($updateTravelsWithPassenger) && empty($updateTravelsWithPassenger))) {
            unset($this->UpdateTravelsWithPassenger);
        } else {
            $this->UpdateTravelsWithPassenger = $updateTravelsWithPassenger;
        }
        return $this;
    }
    /**
     * Get IsFlightDisruptionModify value
     * @return bool|null
     */
    public function getIsFlightDisruptionModify()
    {
        return $this->IsFlightDisruptionModify;
    }
    /**
     * Set IsFlightDisruptionModify value
     * @param bool $isFlightDisruptionModify
     * @return \StructType\ModifyPNR
     */
    public function setIsFlightDisruptionModify($isFlightDisruptionModify = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFlightDisruptionModify) && !is_bool($isFlightDisruptionModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFlightDisruptionModify, true), gettype($isFlightDisruptionModify)), __LINE__);
        }
        $this->IsFlightDisruptionModify = $isFlightDisruptionModify;
        return $this;
    }
    /**
     * Get LogicalFlightKeysToReplace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getLogicalFlightKeysToReplace()
    {
        return isset($this->LogicalFlightKeysToReplace) ? $this->LogicalFlightKeysToReplace : null;
    }
    /**
     * Set LogicalFlightKeysToReplace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $logicalFlightKeysToReplace
     * @return \StructType\ModifyPNR
     */
    public function setLogicalFlightKeysToReplace(\ArrayType\ArrayOfstring $logicalFlightKeysToReplace = null)
    {
        if (is_null($logicalFlightKeysToReplace) || (is_array($logicalFlightKeysToReplace) && empty($logicalFlightKeysToReplace))) {
            unset($this->LogicalFlightKeysToReplace);
        } else {
            $this->LogicalFlightKeysToReplace = $logicalFlightKeysToReplace;
        }
        return $this;
    }
}
