<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPNR.Reservation.Segment.AirlinePerson StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportPNR.Reservation.Segment.AirlinePerson
 * @subpackage Structs
 */
class ImportPNR_Reservation_Segment_AirlinePerson extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The TravelsWithPersonOrgID
     * @var int
     */
    public $TravelsWithPersonOrgID;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The Charges
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Charge
     */
    public $Charges;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Seat
     */
    public $Seats;
    /**
     * Constructor method for ImportPNR.Reservation.Segment.AirlinePerson
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setPersonOrgID()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setTravelsWithPersonOrgID()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setFareClass()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setFareBasisCode()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setRecordLocator()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setCharges()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson::setSeats()
     * @param int $personOrgID
     * @param int $travelsWithPersonOrgID
     * @param string $fareClass
     * @param string $fareBasisCode
     * @param string $recordLocator
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Charge $charges
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Seat $seats
     */
    public function __construct($personOrgID = null, $travelsWithPersonOrgID = null, $fareClass = null, $fareBasisCode = null, $recordLocator = null, \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Charge $charges = null, \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Seat $seats = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setTravelsWithPersonOrgID($travelsWithPersonOrgID)
            ->setFareClass($fareClass)
            ->setFareBasisCode($fareBasisCode)
            ->setRecordLocator($recordLocator)
            ->setCharges($charges)
            ->setSeats($seats);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get TravelsWithPersonOrgID value
     * @return int|null
     */
    public function getTravelsWithPersonOrgID()
    {
        return $this->TravelsWithPersonOrgID;
    }
    /**
     * Set TravelsWithPersonOrgID value
     * @param int $travelsWithPersonOrgID
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setTravelsWithPersonOrgID($travelsWithPersonOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($travelsWithPersonOrgID) && !(is_int($travelsWithPersonOrgID) || ctype_digit($travelsWithPersonOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelsWithPersonOrgID, true), gettype($travelsWithPersonOrgID)), __LINE__);
        }
        $this->TravelsWithPersonOrgID = $travelsWithPersonOrgID;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
    /**
     * Get Charges value
     * @return \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Charge|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Charge $charges
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setCharges(\ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Charge $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Get Seats value
     * @return \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Seat|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Seat $seats
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setSeats(\ArrayType\ArrayOfImportPNR_Reservation_Segment_AirlinePerson_Seat $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
}
