<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPNR.Reservation.Comment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportPNR.Reservation.Comment
 * @subpackage Structs
 */
class ImportPNR_Reservation_Comment extends AbstractStructBase
{
    /**
     * The CommentDate
     * @var string
     */
    public $CommentDate;
    /**
     * The CommentText
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CommentText;
    /**
     * Constructor method for ImportPNR.Reservation.Comment
     * @uses ImportPNR_Reservation_Comment::setCommentDate()
     * @uses ImportPNR_Reservation_Comment::setCommentText()
     * @param string $commentDate
     * @param string $commentText
     */
    public function __construct($commentDate = null, $commentText = null)
    {
        $this
            ->setCommentDate($commentDate)
            ->setCommentText($commentText);
    }
    /**
     * Get CommentDate value
     * @return string|null
     */
    public function getCommentDate()
    {
        return $this->CommentDate;
    }
    /**
     * Set CommentDate value
     * @param string $commentDate
     * @return \StructType\ImportPNR_Reservation_Comment
     */
    public function setCommentDate($commentDate = null)
    {
        // validation for constraint: string
        if (!is_null($commentDate) && !is_string($commentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentDate, true), gettype($commentDate)), __LINE__);
        }
        $this->CommentDate = $commentDate;
        return $this;
    }
    /**
     * Get CommentText value
     * @return string|null
     */
    public function getCommentText()
    {
        return $this->CommentText;
    }
    /**
     * Set CommentText value
     * @param string $commentText
     * @return \StructType\ImportPNR_Reservation_Comment
     */
    public function setCommentText($commentText = null)
    {
        // validation for constraint: string
        if (!is_null($commentText) && !is_string($commentText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentText, true), gettype($commentText)), __LINE__);
        }
        $this->CommentText = $commentText;
        return $this;
    }
}
