<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Charge
 * @subpackage Structs
 */
class Charge extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The ReservationChargeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationChargeID;
    /**
     * The OriginalChargeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginalChargeID;
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * The RefundPersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RefundPersonOrgID;
    /**
     * The RefundType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundType;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherNumber;
    /**
     * The BillDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillDate;
    /**
     * The RPM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RPM;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxID;
    /**
     * The ChargeComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChargeComment;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The ChargeStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChargeStatus;
    /**
     * The IsRefundable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IsRefundable;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The StatusReasonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StatusReasonID;
    /**
     * The IsSSR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSSR;
    /**
     * The PaymentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentNumber;
    /**
     * The LogicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The IncludeInPenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeInPenalty;
    /**
     * The TaxChargeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxChargeID;
    /**
     * The TaxIncludedInFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TaxIncludedInFare;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Commission;
    /**
     * The ResChannelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResChannelId;
    /**
     * The CommissionDueRptCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CommissionDueRptCurrency;
    /**
     * The CommissionDueResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CommissionDueResCurrency;
    /**
     * The NonRefundableResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NonRefundableResCurrency;
    /**
     * The NonRefundableRptCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NonRefundableRptCurrency;
    /**
     * The RefundableResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RefundableResCurrency;
    /**
     * The RefundableRptCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RefundableRptCurrency;
    /**
     * The PenaltyResCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PenaltyResCurrency;
    /**
     * The PenaltyRptCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PenaltyRptCurrency;
    /**
     * The Commissionable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Commissionable;
    /**
     * The NonDiscountedResAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NonDiscountedResAmt;
    /**
     * The NonDiscountedRptAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NonDiscountedRptAmt;
    /**
     * The Bundled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Bundled;
    /**
     * The TaxIsRefundable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TaxIsRefundable;
    /**
     * The TaxIsCommissionable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TaxIsCommissionable;
    /**
     * The ServiceIsRefundable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ServiceIsRefundable;
    /**
     * The ServiceIsCommissionable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ServiceIsCommissionable;
    /**
     * The ReservationPaymentMaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReservationPaymentMap
     */
    public $ReservationPaymentMaps;
    /**
     * The PenaltyChargeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PenaltyChargeID;
    /**
     * The PenaltyTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PenaltyTypeID;
    /**
     * The BoardingPassSsrOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BoardingPassSsrOrder;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The ExtPenaltyRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtPenaltyRule;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCode;
    /**
     * Constructor method for Charge
     * @uses Charge::setKey()
     * @uses Charge::setReservationChargeID()
     * @uses Charge::setOriginalChargeID()
     * @uses Charge::setCodeType()
     * @uses Charge::setRefundPersonOrgID()
     * @uses Charge::setRefundType()
     * @uses Charge::setCurrencyCode()
     * @uses Charge::setOriginalCurrency()
     * @uses Charge::setRecordNumber()
     * @uses Charge::setVoucherNumber()
     * @uses Charge::setBillDate()
     * @uses Charge::setRPM()
     * @uses Charge::setTaxID()
     * @uses Charge::setChargeComment()
     * @uses Charge::setAmount()
     * @uses Charge::setChargeStatus()
     * @uses Charge::setIsRefundable()
     * @uses Charge::setExchangeRate()
     * @uses Charge::setExchangeRateDate()
     * @uses Charge::setOriginalAmount()
     * @uses Charge::setDescription()
     * @uses Charge::setStatusReasonID()
     * @uses Charge::setIsSSR()
     * @uses Charge::setPaymentNumber()
     * @uses Charge::setLogicalFlightID()
     * @uses Charge::setIncludeInPenalty()
     * @uses Charge::setTaxChargeID()
     * @uses Charge::setTaxIncludedInFare()
     * @uses Charge::setCommission()
     * @uses Charge::setResChannelId()
     * @uses Charge::setCommissionDueRptCurrency()
     * @uses Charge::setCommissionDueResCurrency()
     * @uses Charge::setNonRefundableResCurrency()
     * @uses Charge::setNonRefundableRptCurrency()
     * @uses Charge::setRefundableResCurrency()
     * @uses Charge::setRefundableRptCurrency()
     * @uses Charge::setPenaltyResCurrency()
     * @uses Charge::setPenaltyRptCurrency()
     * @uses Charge::setCommissionable()
     * @uses Charge::setNonDiscountedResAmt()
     * @uses Charge::setNonDiscountedRptAmt()
     * @uses Charge::setBundled()
     * @uses Charge::setTaxIsRefundable()
     * @uses Charge::setTaxIsCommissionable()
     * @uses Charge::setServiceIsRefundable()
     * @uses Charge::setServiceIsCommissionable()
     * @uses Charge::setReservationPaymentMaps()
     * @uses Charge::setPenaltyChargeID()
     * @uses Charge::setPenaltyTypeID()
     * @uses Charge::setBoardingPassSsrOrder()
     * @uses Charge::setPhysicalFlightID()
     * @uses Charge::setExtPenaltyRule()
     * @uses Charge::setTaxCode()
     * @param string $key
     * @param int $reservationChargeID
     * @param int $originalChargeID
     * @param string $codeType
     * @param int $refundPersonOrgID
     * @param string $refundType
     * @param string $currencyCode
     * @param string $originalCurrency
     * @param int $recordNumber
     * @param int $voucherNumber
     * @param string $billDate
     * @param int $rPM
     * @param int $taxID
     * @param string $chargeComment
     * @param float $amount
     * @param int $chargeStatus
     * @param int $isRefundable
     * @param float $exchangeRate
     * @param string $exchangeRateDate
     * @param float $originalAmount
     * @param string $description
     * @param int $statusReasonID
     * @param bool $isSSR
     * @param int $paymentNumber
     * @param int $logicalFlightID
     * @param bool $includeInPenalty
     * @param int $taxChargeID
     * @param bool $taxIncludedInFare
     * @param float $commission
     * @param int $resChannelId
     * @param float $commissionDueRptCurrency
     * @param float $commissionDueResCurrency
     * @param float $nonRefundableResCurrency
     * @param float $nonRefundableRptCurrency
     * @param float $refundableResCurrency
     * @param float $refundableRptCurrency
     * @param float $penaltyResCurrency
     * @param float $penaltyRptCurrency
     * @param bool $commissionable
     * @param float $nonDiscountedResAmt
     * @param float $nonDiscountedRptAmt
     * @param bool $bundled
     * @param bool $taxIsRefundable
     * @param bool $taxIsCommissionable
     * @param bool $serviceIsRefundable
     * @param bool $serviceIsCommissionable
     * @param \ArrayType\ArrayOfReservationPaymentMap $reservationPaymentMaps
     * @param int $penaltyChargeID
     * @param int $penaltyTypeID
     * @param int $boardingPassSsrOrder
     * @param int $physicalFlightID
     * @param string $extPenaltyRule
     * @param string $taxCode
     */
    public function __construct($key = null, $reservationChargeID = null, $originalChargeID = null, $codeType = null, $refundPersonOrgID = null, $refundType = null, $currencyCode = null, $originalCurrency = null, $recordNumber = null, $voucherNumber = null, $billDate = null, $rPM = null, $taxID = null, $chargeComment = null, $amount = null, $chargeStatus = null, $isRefundable = null, $exchangeRate = null, $exchangeRateDate = null, $originalAmount = null, $description = null, $statusReasonID = null, $isSSR = null, $paymentNumber = null, $logicalFlightID = null, $includeInPenalty = null, $taxChargeID = null, $taxIncludedInFare = null, $commission = null, $resChannelId = null, $commissionDueRptCurrency = null, $commissionDueResCurrency = null, $nonRefundableResCurrency = null, $nonRefundableRptCurrency = null, $refundableResCurrency = null, $refundableRptCurrency = null, $penaltyResCurrency = null, $penaltyRptCurrency = null, $commissionable = null, $nonDiscountedResAmt = null, $nonDiscountedRptAmt = null, $bundled = null, $taxIsRefundable = null, $taxIsCommissionable = null, $serviceIsRefundable = null, $serviceIsCommissionable = null, \ArrayType\ArrayOfReservationPaymentMap $reservationPaymentMaps = null, $penaltyChargeID = null, $penaltyTypeID = null, $boardingPassSsrOrder = null, $physicalFlightID = null, $extPenaltyRule = null, $taxCode = null)
    {
        $this
            ->setKey($key)
            ->setReservationChargeID($reservationChargeID)
            ->setOriginalChargeID($originalChargeID)
            ->setCodeType($codeType)
            ->setRefundPersonOrgID($refundPersonOrgID)
            ->setRefundType($refundType)
            ->setCurrencyCode($currencyCode)
            ->setOriginalCurrency($originalCurrency)
            ->setRecordNumber($recordNumber)
            ->setVoucherNumber($voucherNumber)
            ->setBillDate($billDate)
            ->setRPM($rPM)
            ->setTaxID($taxID)
            ->setChargeComment($chargeComment)
            ->setAmount($amount)
            ->setChargeStatus($chargeStatus)
            ->setIsRefundable($isRefundable)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateDate($exchangeRateDate)
            ->setOriginalAmount($originalAmount)
            ->setDescription($description)
            ->setStatusReasonID($statusReasonID)
            ->setIsSSR($isSSR)
            ->setPaymentNumber($paymentNumber)
            ->setLogicalFlightID($logicalFlightID)
            ->setIncludeInPenalty($includeInPenalty)
            ->setTaxChargeID($taxChargeID)
            ->setTaxIncludedInFare($taxIncludedInFare)
            ->setCommission($commission)
            ->setResChannelId($resChannelId)
            ->setCommissionDueRptCurrency($commissionDueRptCurrency)
            ->setCommissionDueResCurrency($commissionDueResCurrency)
            ->setNonRefundableResCurrency($nonRefundableResCurrency)
            ->setNonRefundableRptCurrency($nonRefundableRptCurrency)
            ->setRefundableResCurrency($refundableResCurrency)
            ->setRefundableRptCurrency($refundableRptCurrency)
            ->setPenaltyResCurrency($penaltyResCurrency)
            ->setPenaltyRptCurrency($penaltyRptCurrency)
            ->setCommissionable($commissionable)
            ->setNonDiscountedResAmt($nonDiscountedResAmt)
            ->setNonDiscountedRptAmt($nonDiscountedRptAmt)
            ->setBundled($bundled)
            ->setTaxIsRefundable($taxIsRefundable)
            ->setTaxIsCommissionable($taxIsCommissionable)
            ->setServiceIsRefundable($serviceIsRefundable)
            ->setServiceIsCommissionable($serviceIsCommissionable)
            ->setReservationPaymentMaps($reservationPaymentMaps)
            ->setPenaltyChargeID($penaltyChargeID)
            ->setPenaltyTypeID($penaltyTypeID)
            ->setBoardingPassSsrOrder($boardingPassSsrOrder)
            ->setPhysicalFlightID($physicalFlightID)
            ->setExtPenaltyRule($extPenaltyRule)
            ->setTaxCode($taxCode);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Charge
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get ReservationChargeID value
     * @return int|null
     */
    public function getReservationChargeID()
    {
        return $this->ReservationChargeID;
    }
    /**
     * Set ReservationChargeID value
     * @param int $reservationChargeID
     * @return \StructType\Charge
     */
    public function setReservationChargeID($reservationChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChargeID) && !(is_int($reservationChargeID) || ctype_digit($reservationChargeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChargeID, true), gettype($reservationChargeID)), __LINE__);
        }
        $this->ReservationChargeID = $reservationChargeID;
        return $this;
    }
    /**
     * Get OriginalChargeID value
     * @return int|null
     */
    public function getOriginalChargeID()
    {
        return $this->OriginalChargeID;
    }
    /**
     * Set OriginalChargeID value
     * @param int $originalChargeID
     * @return \StructType\Charge
     */
    public function setOriginalChargeID($originalChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($originalChargeID) && !(is_int($originalChargeID) || ctype_digit($originalChargeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalChargeID, true), gettype($originalChargeID)), __LINE__);
        }
        $this->OriginalChargeID = $originalChargeID;
        return $this;
    }
    /**
     * Get CodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeType()
    {
        return isset($this->CodeType) ? $this->CodeType : null;
    }
    /**
     * Set CodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeType
     * @return \StructType\Charge
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        if (is_null($codeType) || (is_array($codeType) && empty($codeType))) {
            unset($this->CodeType);
        } else {
            $this->CodeType = $codeType;
        }
        return $this;
    }
    /**
     * Get RefundPersonOrgID value
     * @return int|null
     */
    public function getRefundPersonOrgID()
    {
        return $this->RefundPersonOrgID;
    }
    /**
     * Set RefundPersonOrgID value
     * @param int $refundPersonOrgID
     * @return \StructType\Charge
     */
    public function setRefundPersonOrgID($refundPersonOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($refundPersonOrgID) && !(is_int($refundPersonOrgID) || ctype_digit($refundPersonOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refundPersonOrgID, true), gettype($refundPersonOrgID)), __LINE__);
        }
        $this->RefundPersonOrgID = $refundPersonOrgID;
        return $this;
    }
    /**
     * Get RefundType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundType()
    {
        return isset($this->RefundType) ? $this->RefundType : null;
    }
    /**
     * Set RefundType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundType
     * @return \StructType\Charge
     */
    public function setRefundType($refundType = null)
    {
        // validation for constraint: string
        if (!is_null($refundType) && !is_string($refundType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundType, true), gettype($refundType)), __LINE__);
        }
        if (is_null($refundType) || (is_array($refundType) && empty($refundType))) {
            unset($this->RefundType);
        } else {
            $this->RefundType = $refundType;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\Charge
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \StructType\Charge
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\Charge
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return int|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param int $voucherNumber
     * @return \StructType\Charge
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNumber) && !(is_int($voucherNumber) || ctype_digit($voucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get BillDate value
     * @return string|null
     */
    public function getBillDate()
    {
        return $this->BillDate;
    }
    /**
     * Set BillDate value
     * @param string $billDate
     * @return \StructType\Charge
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billDate, true), gettype($billDate)), __LINE__);
        }
        $this->BillDate = $billDate;
        return $this;
    }
    /**
     * Get RPM value
     * @return int|null
     */
    public function getRPM()
    {
        return $this->RPM;
    }
    /**
     * Set RPM value
     * @param int $rPM
     * @return \StructType\Charge
     */
    public function setRPM($rPM = null)
    {
        // validation for constraint: int
        if (!is_null($rPM) && !(is_int($rPM) || ctype_digit($rPM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rPM, true), gettype($rPM)), __LINE__);
        }
        $this->RPM = $rPM;
        return $this;
    }
    /**
     * Get TaxID value
     * @return int|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param int $taxID
     * @return \StructType\Charge
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: int
        if (!is_null($taxID) && !(is_int($taxID) || ctype_digit($taxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get ChargeComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChargeComment()
    {
        return isset($this->ChargeComment) ? $this->ChargeComment : null;
    }
    /**
     * Set ChargeComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chargeComment
     * @return \StructType\Charge
     */
    public function setChargeComment($chargeComment = null)
    {
        // validation for constraint: string
        if (!is_null($chargeComment) && !is_string($chargeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeComment, true), gettype($chargeComment)), __LINE__);
        }
        if (is_null($chargeComment) || (is_array($chargeComment) && empty($chargeComment))) {
            unset($this->ChargeComment);
        } else {
            $this->ChargeComment = $chargeComment;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Charge
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ChargeStatus value
     * @return int|null
     */
    public function getChargeStatus()
    {
        return $this->ChargeStatus;
    }
    /**
     * Set ChargeStatus value
     * @param int $chargeStatus
     * @return \StructType\Charge
     */
    public function setChargeStatus($chargeStatus = null)
    {
        // validation for constraint: int
        if (!is_null($chargeStatus) && !(is_int($chargeStatus) || ctype_digit($chargeStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeStatus, true), gettype($chargeStatus)), __LINE__);
        }
        $this->ChargeStatus = $chargeStatus;
        return $this;
    }
    /**
     * Get IsRefundable value
     * @return int|null
     */
    public function getIsRefundable()
    {
        return $this->IsRefundable;
    }
    /**
     * Set IsRefundable value
     * @param int $isRefundable
     * @return \StructType\Charge
     */
    public function setIsRefundable($isRefundable = null)
    {
        // validation for constraint: int
        if (!is_null($isRefundable) && !(is_int($isRefundable) || ctype_digit($isRefundable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isRefundable, true), gettype($isRefundable)), __LINE__);
        }
        $this->IsRefundable = $isRefundable;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Charge
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->ExchangeRateDate;
    }
    /**
     * Set ExchangeRateDate value
     * @param string $exchangeRateDate
     * @return \StructType\Charge
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        $this->ExchangeRateDate = $exchangeRateDate;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\Charge
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Charge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get StatusReasonID value
     * @return int|null
     */
    public function getStatusReasonID()
    {
        return $this->StatusReasonID;
    }
    /**
     * Set StatusReasonID value
     * @param int $statusReasonID
     * @return \StructType\Charge
     */
    public function setStatusReasonID($statusReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($statusReasonID) && !(is_int($statusReasonID) || ctype_digit($statusReasonID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusReasonID, true), gettype($statusReasonID)), __LINE__);
        }
        $this->StatusReasonID = $statusReasonID;
        return $this;
    }
    /**
     * Get IsSSR value
     * @return bool|null
     */
    public function getIsSSR()
    {
        return $this->IsSSR;
    }
    /**
     * Set IsSSR value
     * @param bool $isSSR
     * @return \StructType\Charge
     */
    public function setIsSSR($isSSR = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSSR) && !is_bool($isSSR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSSR, true), gettype($isSSR)), __LINE__);
        }
        $this->IsSSR = $isSSR;
        return $this;
    }
    /**
     * Get PaymentNumber value
     * @return int|null
     */
    public function getPaymentNumber()
    {
        return $this->PaymentNumber;
    }
    /**
     * Set PaymentNumber value
     * @param int $paymentNumber
     * @return \StructType\Charge
     */
    public function setPaymentNumber($paymentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paymentNumber) && !(is_int($paymentNumber) || ctype_digit($paymentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentNumber, true), gettype($paymentNumber)), __LINE__);
        }
        $this->PaymentNumber = $paymentNumber;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\Charge
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get IncludeInPenalty value
     * @return bool|null
     */
    public function getIncludeInPenalty()
    {
        return $this->IncludeInPenalty;
    }
    /**
     * Set IncludeInPenalty value
     * @param bool $includeInPenalty
     * @return \StructType\Charge
     */
    public function setIncludeInPenalty($includeInPenalty = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInPenalty) && !is_bool($includeInPenalty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInPenalty, true), gettype($includeInPenalty)), __LINE__);
        }
        $this->IncludeInPenalty = $includeInPenalty;
        return $this;
    }
    /**
     * Get TaxChargeID value
     * @return int|null
     */
    public function getTaxChargeID()
    {
        return $this->TaxChargeID;
    }
    /**
     * Set TaxChargeID value
     * @param int $taxChargeID
     * @return \StructType\Charge
     */
    public function setTaxChargeID($taxChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($taxChargeID) && !(is_int($taxChargeID) || ctype_digit($taxChargeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxChargeID, true), gettype($taxChargeID)), __LINE__);
        }
        $this->TaxChargeID = $taxChargeID;
        return $this;
    }
    /**
     * Get TaxIncludedInFare value
     * @return bool|null
     */
    public function getTaxIncludedInFare()
    {
        return $this->TaxIncludedInFare;
    }
    /**
     * Set TaxIncludedInFare value
     * @param bool $taxIncludedInFare
     * @return \StructType\Charge
     */
    public function setTaxIncludedInFare($taxIncludedInFare = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIncludedInFare) && !is_bool($taxIncludedInFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxIncludedInFare, true), gettype($taxIncludedInFare)), __LINE__);
        }
        $this->TaxIncludedInFare = $taxIncludedInFare;
        return $this;
    }
    /**
     * Get Commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param float $commission
     * @return \StructType\Charge
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get ResChannelId value
     * @return int|null
     */
    public function getResChannelId()
    {
        return $this->ResChannelId;
    }
    /**
     * Set ResChannelId value
     * @param int $resChannelId
     * @return \StructType\Charge
     */
    public function setResChannelId($resChannelId = null)
    {
        // validation for constraint: int
        if (!is_null($resChannelId) && !(is_int($resChannelId) || ctype_digit($resChannelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resChannelId, true), gettype($resChannelId)), __LINE__);
        }
        $this->ResChannelId = $resChannelId;
        return $this;
    }
    /**
     * Get CommissionDueRptCurrency value
     * @return float|null
     */
    public function getCommissionDueRptCurrency()
    {
        return $this->CommissionDueRptCurrency;
    }
    /**
     * Set CommissionDueRptCurrency value
     * @param float $commissionDueRptCurrency
     * @return \StructType\Charge
     */
    public function setCommissionDueRptCurrency($commissionDueRptCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($commissionDueRptCurrency) && !(is_float($commissionDueRptCurrency) || is_numeric($commissionDueRptCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionDueRptCurrency, true), gettype($commissionDueRptCurrency)), __LINE__);
        }
        $this->CommissionDueRptCurrency = $commissionDueRptCurrency;
        return $this;
    }
    /**
     * Get CommissionDueResCurrency value
     * @return float|null
     */
    public function getCommissionDueResCurrency()
    {
        return $this->CommissionDueResCurrency;
    }
    /**
     * Set CommissionDueResCurrency value
     * @param float $commissionDueResCurrency
     * @return \StructType\Charge
     */
    public function setCommissionDueResCurrency($commissionDueResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($commissionDueResCurrency) && !(is_float($commissionDueResCurrency) || is_numeric($commissionDueResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionDueResCurrency, true), gettype($commissionDueResCurrency)), __LINE__);
        }
        $this->CommissionDueResCurrency = $commissionDueResCurrency;
        return $this;
    }
    /**
     * Get NonRefundableResCurrency value
     * @return float|null
     */
    public function getNonRefundableResCurrency()
    {
        return $this->NonRefundableResCurrency;
    }
    /**
     * Set NonRefundableResCurrency value
     * @param float $nonRefundableResCurrency
     * @return \StructType\Charge
     */
    public function setNonRefundableResCurrency($nonRefundableResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($nonRefundableResCurrency) && !(is_float($nonRefundableResCurrency) || is_numeric($nonRefundableResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonRefundableResCurrency, true), gettype($nonRefundableResCurrency)), __LINE__);
        }
        $this->NonRefundableResCurrency = $nonRefundableResCurrency;
        return $this;
    }
    /**
     * Get NonRefundableRptCurrency value
     * @return float|null
     */
    public function getNonRefundableRptCurrency()
    {
        return $this->NonRefundableRptCurrency;
    }
    /**
     * Set NonRefundableRptCurrency value
     * @param float $nonRefundableRptCurrency
     * @return \StructType\Charge
     */
    public function setNonRefundableRptCurrency($nonRefundableRptCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($nonRefundableRptCurrency) && !(is_float($nonRefundableRptCurrency) || is_numeric($nonRefundableRptCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonRefundableRptCurrency, true), gettype($nonRefundableRptCurrency)), __LINE__);
        }
        $this->NonRefundableRptCurrency = $nonRefundableRptCurrency;
        return $this;
    }
    /**
     * Get RefundableResCurrency value
     * @return float|null
     */
    public function getRefundableResCurrency()
    {
        return $this->RefundableResCurrency;
    }
    /**
     * Set RefundableResCurrency value
     * @param float $refundableResCurrency
     * @return \StructType\Charge
     */
    public function setRefundableResCurrency($refundableResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($refundableResCurrency) && !(is_float($refundableResCurrency) || is_numeric($refundableResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundableResCurrency, true), gettype($refundableResCurrency)), __LINE__);
        }
        $this->RefundableResCurrency = $refundableResCurrency;
        return $this;
    }
    /**
     * Get RefundableRptCurrency value
     * @return float|null
     */
    public function getRefundableRptCurrency()
    {
        return $this->RefundableRptCurrency;
    }
    /**
     * Set RefundableRptCurrency value
     * @param float $refundableRptCurrency
     * @return \StructType\Charge
     */
    public function setRefundableRptCurrency($refundableRptCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($refundableRptCurrency) && !(is_float($refundableRptCurrency) || is_numeric($refundableRptCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundableRptCurrency, true), gettype($refundableRptCurrency)), __LINE__);
        }
        $this->RefundableRptCurrency = $refundableRptCurrency;
        return $this;
    }
    /**
     * Get PenaltyResCurrency value
     * @return float|null
     */
    public function getPenaltyResCurrency()
    {
        return $this->PenaltyResCurrency;
    }
    /**
     * Set PenaltyResCurrency value
     * @param float $penaltyResCurrency
     * @return \StructType\Charge
     */
    public function setPenaltyResCurrency($penaltyResCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($penaltyResCurrency) && !(is_float($penaltyResCurrency) || is_numeric($penaltyResCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltyResCurrency, true), gettype($penaltyResCurrency)), __LINE__);
        }
        $this->PenaltyResCurrency = $penaltyResCurrency;
        return $this;
    }
    /**
     * Get PenaltyRptCurrency value
     * @return float|null
     */
    public function getPenaltyRptCurrency()
    {
        return $this->PenaltyRptCurrency;
    }
    /**
     * Set PenaltyRptCurrency value
     * @param float $penaltyRptCurrency
     * @return \StructType\Charge
     */
    public function setPenaltyRptCurrency($penaltyRptCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($penaltyRptCurrency) && !(is_float($penaltyRptCurrency) || is_numeric($penaltyRptCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltyRptCurrency, true), gettype($penaltyRptCurrency)), __LINE__);
        }
        $this->PenaltyRptCurrency = $penaltyRptCurrency;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\Charge
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get NonDiscountedResAmt value
     * @return float|null
     */
    public function getNonDiscountedResAmt()
    {
        return $this->NonDiscountedResAmt;
    }
    /**
     * Set NonDiscountedResAmt value
     * @param float $nonDiscountedResAmt
     * @return \StructType\Charge
     */
    public function setNonDiscountedResAmt($nonDiscountedResAmt = null)
    {
        // validation for constraint: float
        if (!is_null($nonDiscountedResAmt) && !(is_float($nonDiscountedResAmt) || is_numeric($nonDiscountedResAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonDiscountedResAmt, true), gettype($nonDiscountedResAmt)), __LINE__);
        }
        $this->NonDiscountedResAmt = $nonDiscountedResAmt;
        return $this;
    }
    /**
     * Get NonDiscountedRptAmt value
     * @return float|null
     */
    public function getNonDiscountedRptAmt()
    {
        return $this->NonDiscountedRptAmt;
    }
    /**
     * Set NonDiscountedRptAmt value
     * @param float $nonDiscountedRptAmt
     * @return \StructType\Charge
     */
    public function setNonDiscountedRptAmt($nonDiscountedRptAmt = null)
    {
        // validation for constraint: float
        if (!is_null($nonDiscountedRptAmt) && !(is_float($nonDiscountedRptAmt) || is_numeric($nonDiscountedRptAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonDiscountedRptAmt, true), gettype($nonDiscountedRptAmt)), __LINE__);
        }
        $this->NonDiscountedRptAmt = $nonDiscountedRptAmt;
        return $this;
    }
    /**
     * Get Bundled value
     * @return bool|null
     */
    public function getBundled()
    {
        return $this->Bundled;
    }
    /**
     * Set Bundled value
     * @param bool $bundled
     * @return \StructType\Charge
     */
    public function setBundled($bundled = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundled) && !is_bool($bundled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundled, true), gettype($bundled)), __LINE__);
        }
        $this->Bundled = $bundled;
        return $this;
    }
    /**
     * Get TaxIsRefundable value
     * @return bool|null
     */
    public function getTaxIsRefundable()
    {
        return $this->TaxIsRefundable;
    }
    /**
     * Set TaxIsRefundable value
     * @param bool $taxIsRefundable
     * @return \StructType\Charge
     */
    public function setTaxIsRefundable($taxIsRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIsRefundable) && !is_bool($taxIsRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxIsRefundable, true), gettype($taxIsRefundable)), __LINE__);
        }
        $this->TaxIsRefundable = $taxIsRefundable;
        return $this;
    }
    /**
     * Get TaxIsCommissionable value
     * @return bool|null
     */
    public function getTaxIsCommissionable()
    {
        return $this->TaxIsCommissionable;
    }
    /**
     * Set TaxIsCommissionable value
     * @param bool $taxIsCommissionable
     * @return \StructType\Charge
     */
    public function setTaxIsCommissionable($taxIsCommissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIsCommissionable) && !is_bool($taxIsCommissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxIsCommissionable, true), gettype($taxIsCommissionable)), __LINE__);
        }
        $this->TaxIsCommissionable = $taxIsCommissionable;
        return $this;
    }
    /**
     * Get ServiceIsRefundable value
     * @return bool|null
     */
    public function getServiceIsRefundable()
    {
        return $this->ServiceIsRefundable;
    }
    /**
     * Set ServiceIsRefundable value
     * @param bool $serviceIsRefundable
     * @return \StructType\Charge
     */
    public function setServiceIsRefundable($serviceIsRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceIsRefundable) && !is_bool($serviceIsRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceIsRefundable, true), gettype($serviceIsRefundable)), __LINE__);
        }
        $this->ServiceIsRefundable = $serviceIsRefundable;
        return $this;
    }
    /**
     * Get ServiceIsCommissionable value
     * @return bool|null
     */
    public function getServiceIsCommissionable()
    {
        return $this->ServiceIsCommissionable;
    }
    /**
     * Set ServiceIsCommissionable value
     * @param bool $serviceIsCommissionable
     * @return \StructType\Charge
     */
    public function setServiceIsCommissionable($serviceIsCommissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceIsCommissionable) && !is_bool($serviceIsCommissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceIsCommissionable, true), gettype($serviceIsCommissionable)), __LINE__);
        }
        $this->ServiceIsCommissionable = $serviceIsCommissionable;
        return $this;
    }
    /**
     * Get ReservationPaymentMaps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReservationPaymentMap|null
     */
    public function getReservationPaymentMaps()
    {
        return isset($this->ReservationPaymentMaps) ? $this->ReservationPaymentMaps : null;
    }
    /**
     * Set ReservationPaymentMaps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReservationPaymentMap $reservationPaymentMaps
     * @return \StructType\Charge
     */
    public function setReservationPaymentMaps(\ArrayType\ArrayOfReservationPaymentMap $reservationPaymentMaps = null)
    {
        if (is_null($reservationPaymentMaps) || (is_array($reservationPaymentMaps) && empty($reservationPaymentMaps))) {
            unset($this->ReservationPaymentMaps);
        } else {
            $this->ReservationPaymentMaps = $reservationPaymentMaps;
        }
        return $this;
    }
    /**
     * Get PenaltyChargeID value
     * @return int|null
     */
    public function getPenaltyChargeID()
    {
        return $this->PenaltyChargeID;
    }
    /**
     * Set PenaltyChargeID value
     * @param int $penaltyChargeID
     * @return \StructType\Charge
     */
    public function setPenaltyChargeID($penaltyChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($penaltyChargeID) && !(is_int($penaltyChargeID) || ctype_digit($penaltyChargeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($penaltyChargeID, true), gettype($penaltyChargeID)), __LINE__);
        }
        $this->PenaltyChargeID = $penaltyChargeID;
        return $this;
    }
    /**
     * Get PenaltyTypeID value
     * @return int|null
     */
    public function getPenaltyTypeID()
    {
        return $this->PenaltyTypeID;
    }
    /**
     * Set PenaltyTypeID value
     * @param int $penaltyTypeID
     * @return \StructType\Charge
     */
    public function setPenaltyTypeID($penaltyTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($penaltyTypeID) && !(is_int($penaltyTypeID) || ctype_digit($penaltyTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($penaltyTypeID, true), gettype($penaltyTypeID)), __LINE__);
        }
        $this->PenaltyTypeID = $penaltyTypeID;
        return $this;
    }
    /**
     * Get BoardingPassSsrOrder value
     * @return int|null
     */
    public function getBoardingPassSsrOrder()
    {
        return $this->BoardingPassSsrOrder;
    }
    /**
     * Set BoardingPassSsrOrder value
     * @param int $boardingPassSsrOrder
     * @return \StructType\Charge
     */
    public function setBoardingPassSsrOrder($boardingPassSsrOrder = null)
    {
        // validation for constraint: int
        if (!is_null($boardingPassSsrOrder) && !(is_int($boardingPassSsrOrder) || ctype_digit($boardingPassSsrOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardingPassSsrOrder, true), gettype($boardingPassSsrOrder)), __LINE__);
        }
        $this->BoardingPassSsrOrder = $boardingPassSsrOrder;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return isset($this->PhysicalFlightID) ? $this->PhysicalFlightID : null;
    }
    /**
     * Set PhysicalFlightID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $physicalFlightID
     * @return \StructType\Charge
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        if (is_null($physicalFlightID) || (is_array($physicalFlightID) && empty($physicalFlightID))) {
            unset($this->PhysicalFlightID);
        } else {
            $this->PhysicalFlightID = $physicalFlightID;
        }
        return $this;
    }
    /**
     * Get ExtPenaltyRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtPenaltyRule()
    {
        return isset($this->ExtPenaltyRule) ? $this->ExtPenaltyRule : null;
    }
    /**
     * Set ExtPenaltyRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extPenaltyRule
     * @return \StructType\Charge
     */
    public function setExtPenaltyRule($extPenaltyRule = null)
    {
        // validation for constraint: string
        if (!is_null($extPenaltyRule) && !is_string($extPenaltyRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extPenaltyRule, true), gettype($extPenaltyRule)), __LINE__);
        }
        if (is_null($extPenaltyRule) || (is_array($extPenaltyRule) && empty($extPenaltyRule))) {
            unset($this->ExtPenaltyRule);
        } else {
            $this->ExtPenaltyRule = $extPenaltyRule;
        }
        return $this;
    }
    /**
     * Get TaxCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCode()
    {
        return isset($this->TaxCode) ? $this->TaxCode : null;
    }
    /**
     * Set TaxCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCode
     * @return \StructType\Charge
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        if (is_null($taxCode) || (is_array($taxCode) && empty($taxCode))) {
            unset($this->TaxCode);
        } else {
            $this->TaxCode = $taxCode;
        }
        return $this;
    }
}
