<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelPNR
 * @subpackage Structs
 */
class CancelPNR extends TransactionInfo
{
    /**
     * The CancelPnrRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CancelPNR
     */
    public $CancelPnrRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The IsFlightDisruptionCancel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFlightDisruptionCancel;
    /**
     * Constructor method for CancelPNR
     * @uses CancelPNR::setCancelPnrRequest()
     * @uses CancelPNR::setActionType()
     * @uses CancelPNR::setReservationInfo()
     * @uses CancelPNR::setIsFlightDisruptionCancel()
     * @param \StructType\CancelPNR $cancelPnrRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param bool $isFlightDisruptionCancel
     */
    public function __construct(\StructType\CancelPNR $cancelPnrRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, $isFlightDisruptionCancel = null)
    {
        $this
            ->setCancelPnrRequest($cancelPnrRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setIsFlightDisruptionCancel($isFlightDisruptionCancel);
    }
    /**
     * Get CancelPnrRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CancelPNR|null
     */
    public function getCancelPnrRequest()
    {
        return isset($this->CancelPnrRequest) ? $this->CancelPnrRequest : null;
    }
    /**
     * Set CancelPnrRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CancelPNR $cancelPnrRequest
     * @return \StructType\CancelPNR
     */
    public function setCancelPnrRequest(\StructType\CancelPNR $cancelPnrRequest = null)
    {
        if (is_null($cancelPnrRequest) || (is_array($cancelPnrRequest) && empty($cancelPnrRequest))) {
            unset($this->CancelPnrRequest);
        } else {
            $this->CancelPnrRequest = $cancelPnrRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\CancelPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\CancelPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\CancelPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CancelPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CancelPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\CancelPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\CancelPNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get IsFlightDisruptionCancel value
     * @return bool|null
     */
    public function getIsFlightDisruptionCancel()
    {
        return $this->IsFlightDisruptionCancel;
    }
    /**
     * Set IsFlightDisruptionCancel value
     * @param bool $isFlightDisruptionCancel
     * @return \StructType\CancelPNR
     */
    public function setIsFlightDisruptionCancel($isFlightDisruptionCancel = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFlightDisruptionCancel) && !is_bool($isFlightDisruptionCancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFlightDisruptionCancel, true), gettype($isFlightDisruptionCancel)), __LINE__);
        }
        $this->IsFlightDisruptionCancel = $isFlightDisruptionCancel;
        return $this;
    }
}
