<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Baggage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Baggage
 * @subpackage Structs
 */
class Baggage extends AbstractStructBase
{
    /**
     * The BagId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BagId;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The BagNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BagNumber;
    /**
     * The BagWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BagWeight;
    /**
     * The BagCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BagCode;
    /**
     * The BagChecked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BagChecked;
    /**
     * The Pet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Pet;
    /**
     * The BagActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BagActive;
    /**
     * The BagTagPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BagTagPrinted;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * Constructor method for Baggage
     * @uses Baggage::setBagId()
     * @uses Baggage::setKey()
     * @uses Baggage::setBagNumber()
     * @uses Baggage::setBagWeight()
     * @uses Baggage::setBagCode()
     * @uses Baggage::setBagChecked()
     * @uses Baggage::setPet()
     * @uses Baggage::setBagActive()
     * @uses Baggage::setBagTagPrinted()
     * @uses Baggage::setRecordNumber()
     * @param int $bagId
     * @param string $key
     * @param int $bagNumber
     * @param float $bagWeight
     * @param string $bagCode
     * @param int $bagChecked
     * @param int $pet
     * @param int $bagActive
     * @param int $bagTagPrinted
     * @param int $recordNumber
     */
    public function __construct($bagId = null, $key = null, $bagNumber = null, $bagWeight = null, $bagCode = null, $bagChecked = null, $pet = null, $bagActive = null, $bagTagPrinted = null, $recordNumber = null)
    {
        $this
            ->setBagId($bagId)
            ->setKey($key)
            ->setBagNumber($bagNumber)
            ->setBagWeight($bagWeight)
            ->setBagCode($bagCode)
            ->setBagChecked($bagChecked)
            ->setPet($pet)
            ->setBagActive($bagActive)
            ->setBagTagPrinted($bagTagPrinted)
            ->setRecordNumber($recordNumber);
    }
    /**
     * Get BagId value
     * @return int|null
     */
    public function getBagId()
    {
        return $this->BagId;
    }
    /**
     * Set BagId value
     * @param int $bagId
     * @return \StructType\Baggage
     */
    public function setBagId($bagId = null)
    {
        // validation for constraint: int
        if (!is_null($bagId) && !(is_int($bagId) || ctype_digit($bagId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bagId, true), gettype($bagId)), __LINE__);
        }
        $this->BagId = $bagId;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Baggage
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get BagNumber value
     * @return int|null
     */
    public function getBagNumber()
    {
        return $this->BagNumber;
    }
    /**
     * Set BagNumber value
     * @param int $bagNumber
     * @return \StructType\Baggage
     */
    public function setBagNumber($bagNumber = null)
    {
        // validation for constraint: int
        if (!is_null($bagNumber) && !(is_int($bagNumber) || ctype_digit($bagNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bagNumber, true), gettype($bagNumber)), __LINE__);
        }
        $this->BagNumber = $bagNumber;
        return $this;
    }
    /**
     * Get BagWeight value
     * @return float|null
     */
    public function getBagWeight()
    {
        return $this->BagWeight;
    }
    /**
     * Set BagWeight value
     * @param float $bagWeight
     * @return \StructType\Baggage
     */
    public function setBagWeight($bagWeight = null)
    {
        // validation for constraint: float
        if (!is_null($bagWeight) && !(is_float($bagWeight) || is_numeric($bagWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bagWeight, true), gettype($bagWeight)), __LINE__);
        }
        $this->BagWeight = $bagWeight;
        return $this;
    }
    /**
     * Get BagCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBagCode()
    {
        return isset($this->BagCode) ? $this->BagCode : null;
    }
    /**
     * Set BagCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bagCode
     * @return \StructType\Baggage
     */
    public function setBagCode($bagCode = null)
    {
        // validation for constraint: string
        if (!is_null($bagCode) && !is_string($bagCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bagCode, true), gettype($bagCode)), __LINE__);
        }
        if (is_null($bagCode) || (is_array($bagCode) && empty($bagCode))) {
            unset($this->BagCode);
        } else {
            $this->BagCode = $bagCode;
        }
        return $this;
    }
    /**
     * Get BagChecked value
     * @return int|null
     */
    public function getBagChecked()
    {
        return $this->BagChecked;
    }
    /**
     * Set BagChecked value
     * @param int $bagChecked
     * @return \StructType\Baggage
     */
    public function setBagChecked($bagChecked = null)
    {
        // validation for constraint: int
        if (!is_null($bagChecked) && !(is_int($bagChecked) || ctype_digit($bagChecked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bagChecked, true), gettype($bagChecked)), __LINE__);
        }
        $this->BagChecked = $bagChecked;
        return $this;
    }
    /**
     * Get Pet value
     * @return int|null
     */
    public function getPet()
    {
        return $this->Pet;
    }
    /**
     * Set Pet value
     * @param int $pet
     * @return \StructType\Baggage
     */
    public function setPet($pet = null)
    {
        // validation for constraint: int
        if (!is_null($pet) && !(is_int($pet) || ctype_digit($pet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pet, true), gettype($pet)), __LINE__);
        }
        $this->Pet = $pet;
        return $this;
    }
    /**
     * Get BagActive value
     * @return int|null
     */
    public function getBagActive()
    {
        return $this->BagActive;
    }
    /**
     * Set BagActive value
     * @param int $bagActive
     * @return \StructType\Baggage
     */
    public function setBagActive($bagActive = null)
    {
        // validation for constraint: int
        if (!is_null($bagActive) && !(is_int($bagActive) || ctype_digit($bagActive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bagActive, true), gettype($bagActive)), __LINE__);
        }
        $this->BagActive = $bagActive;
        return $this;
    }
    /**
     * Get BagTagPrinted value
     * @return int|null
     */
    public function getBagTagPrinted()
    {
        return $this->BagTagPrinted;
    }
    /**
     * Set BagTagPrinted value
     * @param int $bagTagPrinted
     * @return \StructType\Baggage
     */
    public function setBagTagPrinted($bagTagPrinted = null)
    {
        // validation for constraint: int
        if (!is_null($bagTagPrinted) && !(is_int($bagTagPrinted) || ctype_digit($bagTagPrinted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bagTagPrinted, true), gettype($bagTagPrinted)), __LINE__);
        }
        $this->BagTagPrinted = $bagTagPrinted;
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\Baggage
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
}
