<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Summary ServiceType
 * @subpackage Services
 */
class Summary extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SummaryPNR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SummaryPNR $parameters
     * @return \StructType\SummaryPNRResponse|bool
     */
    public function SummaryPNR(\StructType\SummaryPNR $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SummaryPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SummaryPNRResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
