<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelPNR
     * Meta information extracted from the WSDL
     * - documentation: <summary> <para>CancelPNR allows for two actions to occur.</para> <para>If action CancelReservation is specified in the request object submitted then the reservation that is associated with the session will be cancelled within the
     * Radxx System. The associated charges that are refundable will be refunded accordingly and any cancellation fees that maybe accessed will be applied</para> <para>If ActionType RevertReservation is specified then this action will rollback any Presaved
     * mofications that may have occured in the in memory object. The end result will put the reservation back to the state that it was in upon initial call to RetrieveReservation.</para> </summary>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelPNR $parameters
     * @return \StructType\CancelPNRResponse|bool
     */
    public function CancelPNR(\StructType\CancelPNR $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelPNRResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
