<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfViewHistoryPNR ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfViewHistoryPNR
 * @subpackage Arrays
 */
class ArrayOfViewHistoryPNR extends AbstractStructArrayBase
{
    /**
     * The ViewHistoryPNR
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ViewHistoryPNR[]
     */
    public $ViewHistoryPNR;
    /**
     * Constructor method for ArrayOfViewHistoryPNR
     * @uses ArrayOfViewHistoryPNR::setViewHistoryPNR()
     * @param \StructType\ViewHistoryPNR[] $viewHistoryPNR
     */
    public function __construct(array $viewHistoryPNR = array())
    {
        $this
            ->setViewHistoryPNR($viewHistoryPNR);
    }
    /**
     * Get ViewHistoryPNR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ViewHistoryPNR[]|null
     */
    public function getViewHistoryPNR()
    {
        return isset($this->ViewHistoryPNR) ? $this->ViewHistoryPNR : null;
    }
    /**
     * This method is responsible for validating the values passed to the setViewHistoryPNR method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViewHistoryPNR method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewHistoryPNRForArrayConstraintsFromSetViewHistoryPNR(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfViewHistoryPNRViewHistoryPNRItem) {
            // validation for constraint: itemType
            if (!$arrayOfViewHistoryPNRViewHistoryPNRItem instanceof \StructType\ViewHistoryPNR) {
                $invalidValues[] = is_object($arrayOfViewHistoryPNRViewHistoryPNRItem) ? get_class($arrayOfViewHistoryPNRViewHistoryPNRItem) : sprintf('%s(%s)', gettype($arrayOfViewHistoryPNRViewHistoryPNRItem), var_export($arrayOfViewHistoryPNRViewHistoryPNRItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ViewHistoryPNR property can only contain items of type \StructType\ViewHistoryPNR, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ViewHistoryPNR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ViewHistoryPNR[] $viewHistoryPNR
     * @return \ArrayType\ArrayOfViewHistoryPNR
     */
    public function setViewHistoryPNR(array $viewHistoryPNR = array())
    {
        // validation for constraint: array
        if ('' !== ($viewHistoryPNRArrayErrorMessage = self::validateViewHistoryPNRForArrayConstraintsFromSetViewHistoryPNR($viewHistoryPNR))) {
            throw new \InvalidArgumentException($viewHistoryPNRArrayErrorMessage, __LINE__);
        }
        if (is_null($viewHistoryPNR) || (is_array($viewHistoryPNR) && empty($viewHistoryPNR))) {
            unset($this->ViewHistoryPNR);
        } else {
            $this->ViewHistoryPNR = $viewHistoryPNR;
        }
        return $this;
    }
    /**
     * Add item to ViewHistoryPNR value
     * @throws \InvalidArgumentException
     * @param \StructType\ViewHistoryPNR $item
     * @return \ArrayType\ArrayOfViewHistoryPNR
     */
    public function addToViewHistoryPNR(\StructType\ViewHistoryPNR $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ViewHistoryPNR) {
            throw new \InvalidArgumentException(sprintf('The ViewHistoryPNR property can only contain items of type \StructType\ViewHistoryPNR, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ViewHistoryPNR[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ViewHistoryPNR|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ViewHistoryPNR|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ViewHistoryPNR|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ViewHistoryPNR|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ViewHistoryPNR|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ViewHistoryPNR
     */
    public function getAttributeName()
    {
        return 'ViewHistoryPNR';
    }
}
