<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Reservation.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Reservation.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreatePNR operation/method
 */
if ($create->CreatePNR(new \StructType\CreatePNR()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Summary ServiceType
 */
$summary = new \ServiceType\Summary($options);
/**
 * Sample call for SummaryPNR operation/method
 */
if ($summary->SummaryPNR(new \StructType\SummaryPNR()) !== false) {
    print_r($summary->getResult());
} else {
    print_r($summary->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for ModifyPNR operation/method
 */
if ($modify->ModifyPNR(new \StructType\ModifyPNR()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelPNR operation/method
 */
if ($cancel->CancelPNR(new \StructType\CancelPNR()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for RetrievePNR operation/method
 */
if ($retrieve->RetrievePNR(new \StructType\RetrievePNR()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveApisInfo operation/method
 */
if ($retrieve->RetrieveApisInfo(new \StructType\RetrieveApisInfo()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrievePNRByRecordLocator operation/method
 */
if ($retrieve->RetrievePNRByRecordLocator(new \StructType\RetrievePNRByRecordLocator()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for ImportPNR operation/method
 */
if ($import->ImportPNR(new \StructType\ImportPNR()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for History ServiceType
 */
$history = new \ServiceType\History($options);
/**
 * Sample call for HistoryPNR operation/method
 */
if ($history->HistoryPNR(new \StructType\HistoryPNR()) !== false) {
    print_r($history->getResult());
} else {
    print_r($history->getLastError());
}
/**
 * Samples for Evaluate ServiceType
 */
$evaluate = new \ServiceType\Evaluate($options);
/**
 * Sample call for EvaluateModificationOfPNR operation/method
 */
if ($evaluate->EvaluateModificationOfPNR(new \StructType\EvaluateModificationOfPNR()) !== false) {
    print_r($evaluate->getResult());
} else {
    print_r($evaluate->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddPenalties operation/method
 */
if ($add->AddPenalties(new \StructType\AddPenalties()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTaxes operation/method
 */
if ($add->AddTaxes(new \StructType\AddTaxes()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUpdateApisInfo operation/method
 */
if ($add->AddUpdateApisInfo(new \StructType\AddUpdateApisInfo()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Override ServiceType
 */
$override = new \ServiceType\Override($options);
/**
 * Sample call for OverrideReservationCharges operation/method
 */
if ($override->OverrideReservationCharges(new \StructType\OverrideReservationCharges()) !== false) {
    print_r($override->getResult());
} else {
    print_r($override->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetReservationsByNationalId operation/method
 */
if ($get->GetReservationsByNationalId(new \StructType\GetReservationsByNationalId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
/**
 * Sample call for ProcessFlightDisruptionAlert operation/method
 */
if ($process->ProcessFlightDisruptionAlert(new \StructType\ProcessFlightDisruptionAlert()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for OAF ServiceType
 */
$oAF = new \ServiceType\OAF($options);
/**
 * Sample call for OAFlightSegments operation/method
 */
if ($oAF->OAFlightSegments(new \StructType\OAFlightSegments()) !== false) {
    print_r($oAF->getResult());
} else {
    print_r($oAF->getLastError());
}
/**
 * Samples for Manual ServiceType
 */
$manual = new \ServiceType\Manual($options);
/**
 * Sample call for ManualRefundCharges operation/method
 */
if ($manual->ManualRefundCharges(new \StructType\ManualRefundCharges()) !== false) {
    print_r($manual->getResult());
} else {
    print_r($manual->getLastError());
}
