<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewImportPNR.Reservation.Segment.AirlinePerson StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewImportPNR.Reservation.Segment.AirlinePerson
 * @subpackage Structs
 */
class ViewImportPNR_Reservation_Segment_AirlinePerson extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The TravelsWithPersonOrgID
     * @var int
     */
    public $TravelsWithPersonOrgID;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The Charges
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Charge
     */
    public $Charges;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Seat
     */
    public $Seats;
    /**
     * Constructor method for ViewImportPNR.Reservation.Segment.AirlinePerson
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson::setPersonOrgID()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson::setTravelsWithPersonOrgID()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson::setFareClass()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson::setFareBasisCode()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson::setCharges()
     * @uses ViewImportPNR_Reservation_Segment_AirlinePerson::setSeats()
     * @param int $personOrgID
     * @param int $travelsWithPersonOrgID
     * @param string $fareClass
     * @param string $fareBasisCode
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Charge $charges
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Seat $seats
     */
    public function __construct($personOrgID = null, $travelsWithPersonOrgID = null, $fareClass = null, $fareBasisCode = null, \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Charge $charges = null, \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Seat $seats = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setTravelsWithPersonOrgID($travelsWithPersonOrgID)
            ->setFareClass($fareClass)
            ->setFareBasisCode($fareBasisCode)
            ->setCharges($charges)
            ->setSeats($seats);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get TravelsWithPersonOrgID value
     * @return int|null
     */
    public function getTravelsWithPersonOrgID()
    {
        return $this->TravelsWithPersonOrgID;
    }
    /**
     * Set TravelsWithPersonOrgID value
     * @param int $travelsWithPersonOrgID
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setTravelsWithPersonOrgID($travelsWithPersonOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($travelsWithPersonOrgID) && !(is_int($travelsWithPersonOrgID) || ctype_digit($travelsWithPersonOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelsWithPersonOrgID, true), gettype($travelsWithPersonOrgID)), __LINE__);
        }
        $this->TravelsWithPersonOrgID = $travelsWithPersonOrgID;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get Charges value
     * @return \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Charge|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Charge $charges
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setCharges(\ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Charge $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Get Seats value
     * @return \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Seat|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Seat $seats
     * @return \StructType\ViewImportPNR_Reservation_Segment_AirlinePerson
     */
    public function setSeats(\ArrayType\ArrayOfViewImportPNR_Reservation_Segment_AirlinePerson_Seat $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
}
