<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SummaryPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SummaryPNR
 * @subpackage Structs
 */
class SummaryPNR extends TransactionInfo
{
    /**
     * The SummaryPnrRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SummaryPNR
     */
    public $SummaryPnrRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The SecurityToken
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SecurityToken;
    /**
     * The CarrierCurrency
     * @var string
     */
    public $CarrierCurrency;
    /**
     * The DisplayCurrency
     * @var string
     */
    public $DisplayCurrency;
    /**
     * The IATANum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATANum;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The ReceiptLanguageID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReceiptLanguageID;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The ExternalBookingID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalBookingID;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfos;
    /**
     * The Passengers
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPerson
     */
    public $Passengers;
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSegment
     */
    public $Segments;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPayment
     */
    public $Payments;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The ReferralID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferralID;
    /**
     * Constructor method for SummaryPNR
     * @uses SummaryPNR::setSummaryPnrRequest()
     * @uses SummaryPNR::setActionType()
     * @uses SummaryPNR::setReservationInfo()
     * @uses SummaryPNR::setSecurityToken()
     * @uses SummaryPNR::setCarrierCurrency()
     * @uses SummaryPNR::setDisplayCurrency()
     * @uses SummaryPNR::setIATANum()
     * @uses SummaryPNR::setUser()
     * @uses SummaryPNR::setReceiptLanguageID()
     * @uses SummaryPNR::setPromoCode()
     * @uses SummaryPNR::setExternalBookingID()
     * @uses SummaryPNR::setAddress()
     * @uses SummaryPNR::setContactInfos()
     * @uses SummaryPNR::setPassengers()
     * @uses SummaryPNR::setSegments()
     * @uses SummaryPNR::setPayments()
     * @uses SummaryPNR::setComment()
     * @uses SummaryPNR::setReferralID()
     * @param \StructType\SummaryPNR $summaryPnrRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $securityToken
     * @param string $carrierCurrency
     * @param string $displayCurrency
     * @param string $iATANum
     * @param string $user
     * @param string $receiptLanguageID
     * @param string $promoCode
     * @param string $externalBookingID
     * @param \StructType\Address $address
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @param \ArrayType\ArrayOfPerson $passengers
     * @param \ArrayType\ArrayOfSegment $segments
     * @param \ArrayType\ArrayOfPayment $payments
     * @param string $comment
     * @param string $referralID
     */
    public function __construct(\StructType\SummaryPNR $summaryPnrRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, $securityToken = null, $carrierCurrency = null, $displayCurrency = null, $iATANum = null, $user = null, $receiptLanguageID = null, $promoCode = null, $externalBookingID = null, \StructType\Address $address = null, \ArrayType\ArrayOfContactInfo $contactInfos = null, \ArrayType\ArrayOfPerson $passengers = null, \ArrayType\ArrayOfSegment $segments = null, \ArrayType\ArrayOfPayment $payments = null, $comment = null, $referralID = null)
    {
        $this
            ->setSummaryPnrRequest($summaryPnrRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setSecurityToken($securityToken)
            ->setCarrierCurrency($carrierCurrency)
            ->setDisplayCurrency($displayCurrency)
            ->setIATANum($iATANum)
            ->setUser($user)
            ->setReceiptLanguageID($receiptLanguageID)
            ->setPromoCode($promoCode)
            ->setExternalBookingID($externalBookingID)
            ->setAddress($address)
            ->setContactInfos($contactInfos)
            ->setPassengers($passengers)
            ->setSegments($segments)
            ->setPayments($payments)
            ->setComment($comment)
            ->setReferralID($referralID);
    }
    /**
     * Get SummaryPnrRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SummaryPNR|null
     */
    public function getSummaryPnrRequest()
    {
        return isset($this->SummaryPnrRequest) ? $this->SummaryPnrRequest : null;
    }
    /**
     * Set SummaryPnrRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SummaryPNR $summaryPnrRequest
     * @return \StructType\SummaryPNR
     */
    public function setSummaryPnrRequest(\StructType\SummaryPNR $summaryPnrRequest = null)
    {
        if (is_null($summaryPnrRequest) || (is_array($summaryPnrRequest) && empty($summaryPnrRequest))) {
            unset($this->SummaryPnrRequest);
        } else {
            $this->SummaryPnrRequest = $summaryPnrRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\SummaryPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\SummaryPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\SummaryPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SummaryPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SummaryPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\SummaryPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\SummaryPNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get SecurityToken value
     * @return string|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param string $securityToken
     * @return \StructType\SummaryPNR
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Get CarrierCurrency value
     * @return string|null
     */
    public function getCarrierCurrency()
    {
        return $this->CarrierCurrency;
    }
    /**
     * Set CarrierCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrierCurrency
     * @return \StructType\SummaryPNR
     */
    public function setCarrierCurrency($carrierCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($carrierCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($carrierCurrency) ? implode(', ', $carrierCurrency) : var_export($carrierCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CarrierCurrency = $carrierCurrency;
        return $this;
    }
    /**
     * Get DisplayCurrency value
     * @return string|null
     */
    public function getDisplayCurrency()
    {
        return $this->DisplayCurrency;
    }
    /**
     * Set DisplayCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayCurrency
     * @return \StructType\SummaryPNR
     */
    public function setDisplayCurrency($displayCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($displayCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($displayCurrency) ? implode(', ', $displayCurrency) : var_export($displayCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->DisplayCurrency = $displayCurrency;
        return $this;
    }
    /**
     * Get IATANum value
     * @return string|null
     */
    public function getIATANum()
    {
        return $this->IATANum;
    }
    /**
     * Set IATANum value
     * @param string $iATANum
     * @return \StructType\SummaryPNR
     */
    public function setIATANum($iATANum = null)
    {
        // validation for constraint: string
        if (!is_null($iATANum) && !is_string($iATANum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANum, true), gettype($iATANum)), __LINE__);
        }
        $this->IATANum = $iATANum;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\SummaryPNR
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get ReceiptLanguageID value
     * @return string|null
     */
    public function getReceiptLanguageID()
    {
        return $this->ReceiptLanguageID;
    }
    /**
     * Set ReceiptLanguageID value
     * @param string $receiptLanguageID
     * @return \StructType\SummaryPNR
     */
    public function setReceiptLanguageID($receiptLanguageID = null)
    {
        // validation for constraint: string
        if (!is_null($receiptLanguageID) && !is_string($receiptLanguageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptLanguageID, true), gettype($receiptLanguageID)), __LINE__);
        }
        $this->ReceiptLanguageID = $receiptLanguageID;
        return $this;
    }
    /**
     * Get PromoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \StructType\SummaryPNR
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get ExternalBookingID value
     * @return string|null
     */
    public function getExternalBookingID()
    {
        return $this->ExternalBookingID;
    }
    /**
     * Set ExternalBookingID value
     * @param string $externalBookingID
     * @return \StructType\SummaryPNR
     */
    public function setExternalBookingID($externalBookingID = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingID) && !is_string($externalBookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingID, true), gettype($externalBookingID)), __LINE__);
        }
        $this->ExternalBookingID = $externalBookingID;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\SummaryPNR
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactInfos value
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfos()
    {
        return $this->ContactInfos;
    }
    /**
     * Set ContactInfos value
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @return \StructType\SummaryPNR
     */
    public function setContactInfos(\ArrayType\ArrayOfContactInfo $contactInfos = null)
    {
        $this->ContactInfos = $contactInfos;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \ArrayType\ArrayOfPerson|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \ArrayType\ArrayOfPerson $passengers
     * @return \StructType\SummaryPNR
     */
    public function setPassengers(\ArrayType\ArrayOfPerson $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get Segments value
     * @return \ArrayType\ArrayOfSegment|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @param \ArrayType\ArrayOfSegment $segments
     * @return \StructType\SummaryPNR
     */
    public function setSegments(\ArrayType\ArrayOfSegment $segments = null)
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Get Payments value
     * @return \ArrayType\ArrayOfPayment|null
     */
    public function getPayments()
    {
        return $this->Payments;
    }
    /**
     * Set Payments value
     * @param \ArrayType\ArrayOfPayment $payments
     * @return \StructType\SummaryPNR
     */
    public function setPayments(\ArrayType\ArrayOfPayment $payments = null)
    {
        $this->Payments = $payments;
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\SummaryPNR
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get ReferralID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferralID()
    {
        return isset($this->ReferralID) ? $this->ReferralID : null;
    }
    /**
     * Set ReferralID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referralID
     * @return \StructType\SummaryPNR
     */
    public function setReferralID($referralID = null)
    {
        // validation for constraint: string
        if (!is_null($referralID) && !is_string($referralID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referralID, true), gettype($referralID)), __LINE__);
        }
        if (is_null($referralID) || (is_array($referralID) && empty($referralID))) {
            unset($this->ReferralID);
        } else {
            $this->ReferralID = $referralID;
        }
        return $this;
    }
}
