<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrievePNRByRecordLocator StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrievePNRByRecordLocator
 * @subpackage Structs
 */
class RetrievePNRByRecordLocator extends TransactionInfo
{
    /**
     * The RetrievePNRByRecordLocatorRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrievePNRByRecordLocator
     */
    public $RetrievePNRByRecordLocatorRequest;
    /**
     * The CRSCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CRSCode;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The FlightNumber
     * @var int
     */
    public $FlightNumber;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * Constructor method for RetrievePNRByRecordLocator
     * @uses RetrievePNRByRecordLocator::setRetrievePNRByRecordLocatorRequest()
     * @uses RetrievePNRByRecordLocator::setCRSCode()
     * @uses RetrievePNRByRecordLocator::setDepartureDate()
     * @uses RetrievePNRByRecordLocator::setDestination()
     * @uses RetrievePNRByRecordLocator::setFlightNumber()
     * @uses RetrievePNRByRecordLocator::setOrigin()
     * @uses RetrievePNRByRecordLocator::setRecordLocator()
     * @param \StructType\RetrievePNRByRecordLocator $retrievePNRByRecordLocatorRequest
     * @param string $cRSCode
     * @param string $departureDate
     * @param string $destination
     * @param int $flightNumber
     * @param string $origin
     * @param string $recordLocator
     */
    public function __construct(\StructType\RetrievePNRByRecordLocator $retrievePNRByRecordLocatorRequest = null, $cRSCode = null, $departureDate = null, $destination = null, $flightNumber = null, $origin = null, $recordLocator = null)
    {
        $this
            ->setRetrievePNRByRecordLocatorRequest($retrievePNRByRecordLocatorRequest)
            ->setCRSCode($cRSCode)
            ->setDepartureDate($departureDate)
            ->setDestination($destination)
            ->setFlightNumber($flightNumber)
            ->setOrigin($origin)
            ->setRecordLocator($recordLocator);
    }
    /**
     * Get RetrievePNRByRecordLocatorRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrievePNRByRecordLocator|null
     */
    public function getRetrievePNRByRecordLocatorRequest()
    {
        return isset($this->RetrievePNRByRecordLocatorRequest) ? $this->RetrievePNRByRecordLocatorRequest : null;
    }
    /**
     * Set RetrievePNRByRecordLocatorRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrievePNRByRecordLocator $retrievePNRByRecordLocatorRequest
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setRetrievePNRByRecordLocatorRequest(\StructType\RetrievePNRByRecordLocator $retrievePNRByRecordLocatorRequest = null)
    {
        if (is_null($retrievePNRByRecordLocatorRequest) || (is_array($retrievePNRByRecordLocatorRequest) && empty($retrievePNRByRecordLocatorRequest))) {
            unset($this->RetrievePNRByRecordLocatorRequest);
        } else {
            $this->RetrievePNRByRecordLocatorRequest = $retrievePNRByRecordLocatorRequest;
        }
        return $this;
    }
    /**
     * Get CRSCode value
     * @return string|null
     */
    public function getCRSCode()
    {
        return $this->CRSCode;
    }
    /**
     * Set CRSCode value
     * @param string $cRSCode
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setCRSCode($cRSCode = null)
    {
        // validation for constraint: string
        if (!is_null($cRSCode) && !is_string($cRSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSCode, true), gettype($cRSCode)), __LINE__);
        }
        $this->CRSCode = $cRSCode;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return int|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param int $flightNumber
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: int
        if (!is_null($flightNumber) && !(is_int($flightNumber) || ctype_digit($flightNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get RecordLocator value
     * @return string|null
     */
    public function getRecordLocator()
    {
        return $this->RecordLocator;
    }
    /**
     * Set RecordLocator value
     * @param string $recordLocator
     * @return \StructType\RetrievePNRByRecordLocator
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        $this->RecordLocator = $recordLocator;
        return $this;
    }
}
