<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationToInsertHistory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationToInsertHistory
 * @subpackage Structs
 */
class ReservationToInsertHistory extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The HistoryEventText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoryEventText;
    /**
     * The Passenger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Passenger;
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Segment;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The ResChannel
     * @var string
     */
    public $ResChannel;
    /**
     * The UpdatedPNRHistory
     * @var bool
     */
    public $UpdatedPNRHistory;
    /**
     * The UpdateDate
     * @var string
     */
    public $UpdateDate;
    /**
     * The IPAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IPAddress;
    /**
     * Constructor method for ReservationToInsertHistory
     * @uses ReservationToInsertHistory::setAction()
     * @uses ReservationToInsertHistory::setHistoryEventText()
     * @uses ReservationToInsertHistory::setPassenger()
     * @uses ReservationToInsertHistory::setSegment()
     * @uses ReservationToInsertHistory::setDescription()
     * @uses ReservationToInsertHistory::setUser()
     * @uses ReservationToInsertHistory::setResChannel()
     * @uses ReservationToInsertHistory::setUpdatedPNRHistory()
     * @uses ReservationToInsertHistory::setUpdateDate()
     * @uses ReservationToInsertHistory::setIPAddress()
     * @param string $action
     * @param string $historyEventText
     * @param string $passenger
     * @param string $segment
     * @param string $description
     * @param string $user
     * @param string $resChannel
     * @param bool $updatedPNRHistory
     * @param string $updateDate
     * @param string $iPAddress
     */
    public function __construct($action = null, $historyEventText = null, $passenger = null, $segment = null, $description = null, $user = null, $resChannel = null, $updatedPNRHistory = null, $updateDate = null, $iPAddress = null)
    {
        $this
            ->setAction($action)
            ->setHistoryEventText($historyEventText)
            ->setPassenger($passenger)
            ->setSegment($segment)
            ->setDescription($description)
            ->setUser($user)
            ->setResChannel($resChannel)
            ->setUpdatedPNRHistory($updatedPNRHistory)
            ->setUpdateDate($updateDate)
            ->setIPAddress($iPAddress);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \StructType\ReservationToInsertHistory
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get HistoryEventText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoryEventText()
    {
        return isset($this->HistoryEventText) ? $this->HistoryEventText : null;
    }
    /**
     * Set HistoryEventText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historyEventText
     * @return \StructType\ReservationToInsertHistory
     */
    public function setHistoryEventText($historyEventText = null)
    {
        // validation for constraint: string
        if (!is_null($historyEventText) && !is_string($historyEventText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historyEventText, true), gettype($historyEventText)), __LINE__);
        }
        if (is_null($historyEventText) || (is_array($historyEventText) && empty($historyEventText))) {
            unset($this->HistoryEventText);
        } else {
            $this->HistoryEventText = $historyEventText;
        }
        return $this;
    }
    /**
     * Get Passenger value
     * @return string|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @param string $passenger
     * @return \StructType\ReservationToInsertHistory
     */
    public function setPassenger($passenger = null)
    {
        // validation for constraint: string
        if (!is_null($passenger) && !is_string($passenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passenger, true), gettype($passenger)), __LINE__);
        }
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Get Segment value
     * @return string|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param string $segment
     * @return \StructType\ReservationToInsertHistory
     */
    public function setSegment($segment = null)
    {
        // validation for constraint: string
        if (!is_null($segment) && !is_string($segment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment, true), gettype($segment)), __LINE__);
        }
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ReservationToInsertHistory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\ReservationToInsertHistory
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get ResChannel value
     * @return string|null
     */
    public function getResChannel()
    {
        return $this->ResChannel;
    }
    /**
     * Set ResChannel value
     * @uses \EnumType\Enumerations_ReservationChannelTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ReservationChannelTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resChannel
     * @return \StructType\ReservationToInsertHistory
     */
    public function setResChannel($resChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ReservationChannelTypes::valueIsValid($resChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ReservationChannelTypes', is_array($resChannel) ? implode(', ', $resChannel) : var_export($resChannel, true), implode(', ', \EnumType\Enumerations_ReservationChannelTypes::getValidValues())), __LINE__);
        }
        $this->ResChannel = $resChannel;
        return $this;
    }
    /**
     * Get UpdatedPNRHistory value
     * @return bool|null
     */
    public function getUpdatedPNRHistory()
    {
        return $this->UpdatedPNRHistory;
    }
    /**
     * Set UpdatedPNRHistory value
     * @param bool $updatedPNRHistory
     * @return \StructType\ReservationToInsertHistory
     */
    public function setUpdatedPNRHistory($updatedPNRHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($updatedPNRHistory) && !is_bool($updatedPNRHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updatedPNRHistory, true), gettype($updatedPNRHistory)), __LINE__);
        }
        $this->UpdatedPNRHistory = $updatedPNRHistory;
        return $this;
    }
    /**
     * Get UpdateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->UpdateDate;
    }
    /**
     * Set UpdateDate value
     * @param string $updateDate
     * @return \StructType\ReservationToInsertHistory
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        $this->UpdateDate = $updateDate;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \StructType\ReservationToInsertHistory
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPAddress, true), gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
}
