<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundChargeDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundChargeDetail
 * @subpackage Structs
 */
class RefundChargeDetail extends AbstractStructBase
{
    /**
     * The ChargeKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChargeKey;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for RefundChargeDetail
     * @uses RefundChargeDetail::setChargeKey()
     * @uses RefundChargeDetail::setAmount()
     * @param string $chargeKey
     * @param float $amount
     */
    public function __construct($chargeKey = null, $amount = null)
    {
        $this
            ->setChargeKey($chargeKey)
            ->setAmount($amount);
    }
    /**
     * Get ChargeKey value
     * @return string|null
     */
    public function getChargeKey()
    {
        return $this->ChargeKey;
    }
    /**
     * Set ChargeKey value
     * @param string $chargeKey
     * @return \StructType\RefundChargeDetail
     */
    public function setChargeKey($chargeKey = null)
    {
        // validation for constraint: string
        if (!is_null($chargeKey) && !is_string($chargeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeKey, true), gettype($chargeKey)), __LINE__);
        }
        $this->ChargeKey = $chargeKey;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\RefundChargeDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
