<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Person
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age;
    /**
     * The DOB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DOB;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The NationalityLaguageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NationalityLaguageID;
    /**
     * The RelationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationType;
    /**
     * The WBCID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WBCID;
    /**
     * The PTCID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PTCID;
    /**
     * The PTC
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PTC;
    /**
     * The TravelsWithPersonOrgID
     * @var int
     */
    public $TravelsWithPersonOrgID;
    /**
     * The RedressNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RedressNumber;
    /**
     * The KnownTravelerNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $KnownTravelerNumber;
    /**
     * The MarketingOptIn
     * @var bool
     */
    public $MarketingOptIn;
    /**
     * The UseInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseInventory;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The Passport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Passport;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nationality;
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileId;
    /**
     * The IsPrimaryPassenger
     * @var bool
     */
    public $IsPrimaryPassenger;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfos;
    /**
     * The FrequentFlyerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Weight;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Postal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postal;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * Constructor method for Person
     * @uses Person::setPersonOrgID()
     * @uses Person::setFirstName()
     * @uses Person::setLastName()
     * @uses Person::setMiddleName()
     * @uses Person::setAge()
     * @uses Person::setDOB()
     * @uses Person::setGender()
     * @uses Person::setTitle()
     * @uses Person::setNationalityLaguageID()
     * @uses Person::setRelationType()
     * @uses Person::setWBCID()
     * @uses Person::setPTCID()
     * @uses Person::setPTC()
     * @uses Person::setTravelsWithPersonOrgID()
     * @uses Person::setRedressNumber()
     * @uses Person::setKnownTravelerNumber()
     * @uses Person::setMarketingOptIn()
     * @uses Person::setUseInventory()
     * @uses Person::setAddress()
     * @uses Person::setCompany()
     * @uses Person::setComments()
     * @uses Person::setPassport()
     * @uses Person::setNationality()
     * @uses Person::setProfileId()
     * @uses Person::setIsPrimaryPassenger()
     * @uses Person::setContactInfos()
     * @uses Person::setFrequentFlyerNumber()
     * @uses Person::setSuffix()
     * @uses Person::setWeight()
     * @uses Person::setHeight()
     * @uses Person::setKey()
     * @uses Person::setAddress2()
     * @uses Person::setCity()
     * @uses Person::setState()
     * @uses Person::setPostal()
     * @uses Person::setCountry()
     * @param int $personOrgID
     * @param string $firstName
     * @param string $lastName
     * @param string $middleName
     * @param int $age
     * @param string $dOB
     * @param string $gender
     * @param string $title
     * @param int $nationalityLaguageID
     * @param string $relationType
     * @param int $wBCID
     * @param int $pTCID
     * @param string $pTC
     * @param int $travelsWithPersonOrgID
     * @param string $redressNumber
     * @param string $knownTravelerNumber
     * @param bool $marketingOptIn
     * @param bool $useInventory
     * @param \StructType\Address $address
     * @param string $company
     * @param string $comments
     * @param string $passport
     * @param string $nationality
     * @param int $profileId
     * @param bool $isPrimaryPassenger
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @param string $frequentFlyerNumber
     * @param string $suffix
     * @param float $weight
     * @param int $height
     * @param string $key
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $postal
     * @param string $country
     */
    public function __construct($personOrgID = null, $firstName = null, $lastName = null, $middleName = null, $age = null, $dOB = null, $gender = null, $title = null, $nationalityLaguageID = null, $relationType = null, $wBCID = null, $pTCID = null, $pTC = null, $travelsWithPersonOrgID = null, $redressNumber = null, $knownTravelerNumber = null, $marketingOptIn = null, $useInventory = null, \StructType\Address $address = null, $company = null, $comments = null, $passport = null, $nationality = null, $profileId = null, $isPrimaryPassenger = null, \ArrayType\ArrayOfContactInfo $contactInfos = null, $frequentFlyerNumber = null, $suffix = null, $weight = null, $height = null, $key = null, $address2 = null, $city = null, $state = null, $postal = null, $country = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setAge($age)
            ->setDOB($dOB)
            ->setGender($gender)
            ->setTitle($title)
            ->setNationalityLaguageID($nationalityLaguageID)
            ->setRelationType($relationType)
            ->setWBCID($wBCID)
            ->setPTCID($pTCID)
            ->setPTC($pTC)
            ->setTravelsWithPersonOrgID($travelsWithPersonOrgID)
            ->setRedressNumber($redressNumber)
            ->setKnownTravelerNumber($knownTravelerNumber)
            ->setMarketingOptIn($marketingOptIn)
            ->setUseInventory($useInventory)
            ->setAddress($address)
            ->setCompany($company)
            ->setComments($comments)
            ->setPassport($passport)
            ->setNationality($nationality)
            ->setProfileId($profileId)
            ->setIsPrimaryPassenger($isPrimaryPassenger)
            ->setContactInfos($contactInfos)
            ->setFrequentFlyerNumber($frequentFlyerNumber)
            ->setSuffix($suffix)
            ->setWeight($weight)
            ->setHeight($height)
            ->setKey($key)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setPostal($postal)
            ->setCountry($country);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\Person
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Person
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Person
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \StructType\Person
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\Person
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\Person
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Enumerations_GenderTypes::valueIsValid()
     * @uses \EnumType\Enumerations_GenderTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\Person
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_GenderTypes::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_GenderTypes', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\Enumerations_GenderTypes::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\Person
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get NationalityLaguageID value
     * @return int|null
     */
    public function getNationalityLaguageID()
    {
        return $this->NationalityLaguageID;
    }
    /**
     * Set NationalityLaguageID value
     * @param int $nationalityLaguageID
     * @return \StructType\Person
     */
    public function setNationalityLaguageID($nationalityLaguageID = null)
    {
        // validation for constraint: int
        if (!is_null($nationalityLaguageID) && !(is_int($nationalityLaguageID) || ctype_digit($nationalityLaguageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nationalityLaguageID, true), gettype($nationalityLaguageID)), __LINE__);
        }
        $this->NationalityLaguageID = $nationalityLaguageID;
        return $this;
    }
    /**
     * Get RelationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationType()
    {
        return isset($this->RelationType) ? $this->RelationType : null;
    }
    /**
     * Set RelationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Enumerations_RelationshipTypes::valueIsValid()
     * @uses \EnumType\Enumerations_RelationshipTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationType
     * @return \StructType\Person
     */
    public function setRelationType($relationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_RelationshipTypes::valueIsValid($relationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_RelationshipTypes', is_array($relationType) ? implode(', ', $relationType) : var_export($relationType, true), implode(', ', \EnumType\Enumerations_RelationshipTypes::getValidValues())), __LINE__);
        }
        if (is_null($relationType) || (is_array($relationType) && empty($relationType))) {
            unset($this->RelationType);
        } else {
            $this->RelationType = $relationType;
        }
        return $this;
    }
    /**
     * Get WBCID value
     * @return int|null
     */
    public function getWBCID()
    {
        return $this->WBCID;
    }
    /**
     * Set WBCID value
     * @param int $wBCID
     * @return \StructType\Person
     */
    public function setWBCID($wBCID = null)
    {
        // validation for constraint: int
        if (!is_null($wBCID) && !(is_int($wBCID) || ctype_digit($wBCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wBCID, true), gettype($wBCID)), __LINE__);
        }
        $this->WBCID = $wBCID;
        return $this;
    }
    /**
     * Get PTCID value
     * @return int|null
     */
    public function getPTCID()
    {
        return $this->PTCID;
    }
    /**
     * Set PTCID value
     * @param int $pTCID
     * @return \StructType\Person
     */
    public function setPTCID($pTCID = null)
    {
        // validation for constraint: int
        if (!is_null($pTCID) && !(is_int($pTCID) || ctype_digit($pTCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTCID, true), gettype($pTCID)), __LINE__);
        }
        $this->PTCID = $pTCID;
        return $this;
    }
    /**
     * Get PTC value
     * @return string|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * Set PTC value
     * @param string $pTC
     * @return \StructType\Person
     */
    public function setPTC($pTC = null)
    {
        // validation for constraint: string
        if (!is_null($pTC) && !is_string($pTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTC, true), gettype($pTC)), __LINE__);
        }
        $this->PTC = $pTC;
        return $this;
    }
    /**
     * Get TravelsWithPersonOrgID value
     * @return int|null
     */
    public function getTravelsWithPersonOrgID()
    {
        return $this->TravelsWithPersonOrgID;
    }
    /**
     * Set TravelsWithPersonOrgID value
     * @param int $travelsWithPersonOrgID
     * @return \StructType\Person
     */
    public function setTravelsWithPersonOrgID($travelsWithPersonOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($travelsWithPersonOrgID) && !(is_int($travelsWithPersonOrgID) || ctype_digit($travelsWithPersonOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelsWithPersonOrgID, true), gettype($travelsWithPersonOrgID)), __LINE__);
        }
        $this->TravelsWithPersonOrgID = $travelsWithPersonOrgID;
        return $this;
    }
    /**
     * Get RedressNumber value
     * @return string|null
     */
    public function getRedressNumber()
    {
        return $this->RedressNumber;
    }
    /**
     * Set RedressNumber value
     * @param string $redressNumber
     * @return \StructType\Person
     */
    public function setRedressNumber($redressNumber = null)
    {
        // validation for constraint: string
        if (!is_null($redressNumber) && !is_string($redressNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redressNumber, true), gettype($redressNumber)), __LINE__);
        }
        $this->RedressNumber = $redressNumber;
        return $this;
    }
    /**
     * Get KnownTravelerNumber value
     * @return string|null
     */
    public function getKnownTravelerNumber()
    {
        return $this->KnownTravelerNumber;
    }
    /**
     * Set KnownTravelerNumber value
     * @param string $knownTravelerNumber
     * @return \StructType\Person
     */
    public function setKnownTravelerNumber($knownTravelerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($knownTravelerNumber) && !is_string($knownTravelerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knownTravelerNumber, true), gettype($knownTravelerNumber)), __LINE__);
        }
        $this->KnownTravelerNumber = $knownTravelerNumber;
        return $this;
    }
    /**
     * Get MarketingOptIn value
     * @return bool|null
     */
    public function getMarketingOptIn()
    {
        return $this->MarketingOptIn;
    }
    /**
     * Set MarketingOptIn value
     * @param bool $marketingOptIn
     * @return \StructType\Person
     */
    public function setMarketingOptIn($marketingOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketingOptIn) && !is_bool($marketingOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketingOptIn, true), gettype($marketingOptIn)), __LINE__);
        }
        $this->MarketingOptIn = $marketingOptIn;
        return $this;
    }
    /**
     * Get UseInventory value
     * @return bool|null
     */
    public function getUseInventory()
    {
        return $this->UseInventory;
    }
    /**
     * Set UseInventory value
     * @param bool $useInventory
     * @return \StructType\Person
     */
    public function setUseInventory($useInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($useInventory) && !is_bool($useInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useInventory, true), gettype($useInventory)), __LINE__);
        }
        $this->UseInventory = $useInventory;
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $address
     * @return \StructType\Person
     */
    public function setAddress(\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \StructType\Person
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \StructType\Person
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get Passport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassport()
    {
        return isset($this->Passport) ? $this->Passport : null;
    }
    /**
     * Set Passport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passport
     * @return \StructType\Person
     */
    public function setPassport($passport = null)
    {
        // validation for constraint: string
        if (!is_null($passport) && !is_string($passport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passport, true), gettype($passport)), __LINE__);
        }
        if (is_null($passport) || (is_array($passport) && empty($passport))) {
            unset($this->Passport);
        } else {
            $this->Passport = $passport;
        }
        return $this;
    }
    /**
     * Get Nationality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationality()
    {
        return isset($this->Nationality) ? $this->Nationality : null;
    }
    /**
     * Set Nationality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationality
     * @return \StructType\Person
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        if (is_null($nationality) || (is_array($nationality) && empty($nationality))) {
            unset($this->Nationality);
        } else {
            $this->Nationality = $nationality;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\Person
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get IsPrimaryPassenger value
     * @return bool|null
     */
    public function getIsPrimaryPassenger()
    {
        return $this->IsPrimaryPassenger;
    }
    /**
     * Set IsPrimaryPassenger value
     * @param bool $isPrimaryPassenger
     * @return \StructType\Person
     */
    public function setIsPrimaryPassenger($isPrimaryPassenger = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimaryPassenger) && !is_bool($isPrimaryPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimaryPassenger, true), gettype($isPrimaryPassenger)), __LINE__);
        }
        $this->IsPrimaryPassenger = $isPrimaryPassenger;
        return $this;
    }
    /**
     * Get ContactInfos value
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfos()
    {
        return $this->ContactInfos;
    }
    /**
     * Set ContactInfos value
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @return \StructType\Person
     */
    public function setContactInfos(\ArrayType\ArrayOfContactInfo $contactInfos = null)
    {
        $this->ContactInfos = $contactInfos;
        return $this;
    }
    /**
     * Get FrequentFlyerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return isset($this->FrequentFlyerNumber) ? $this->FrequentFlyerNumber : null;
    }
    /**
     * Set FrequentFlyerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerNumber
     * @return \StructType\Person
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumber) && !is_string($frequentFlyerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerNumber, true), gettype($frequentFlyerNumber)), __LINE__);
        }
        if (is_null($frequentFlyerNumber) || (is_array($frequentFlyerNumber) && empty($frequentFlyerNumber))) {
            unset($this->FrequentFlyerNumber);
        } else {
            $this->FrequentFlyerNumber = $frequentFlyerNumber;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \StructType\Person
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\Person
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\Person
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Person
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get Address2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress2()
    {
        return isset($this->Address2) ? $this->Address2 : null;
    }
    /**
     * Set Address2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address2
     * @return \StructType\Person
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        if (is_null($address2) || (is_array($address2) && empty($address2))) {
            unset($this->Address2);
        } else {
            $this->Address2 = $address2;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\Person
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\Person
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Postal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostal()
    {
        return isset($this->Postal) ? $this->Postal : null;
    }
    /**
     * Set Postal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postal
     * @return \StructType\Person
     */
    public function setPostal($postal = null)
    {
        // validation for constraint: string
        if (!is_null($postal) && !is_string($postal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postal, true), gettype($postal)), __LINE__);
        }
        if (is_null($postal) || (is_array($postal) && empty($postal))) {
            unset($this->Postal);
        } else {
            $this->Postal = $postal;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\Person
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
}
