<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OALSegment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OALSegment
 * @subpackage Structs
 */
class OALSegment extends AbstractStructBase
{
    /**
     * The OALCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OALCarrierCode;
    /**
     * The OALFlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OALFlightNumber;
    /**
     * The OALDepartureDate
     * @var string
     */
    public $OALDepartureDate;
    /**
     * The OALOrigin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OALOrigin;
    /**
     * The OALDestination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OALDestination;
    /**
     * The OALScheduledDepartureTime
     * @var string
     */
    public $OALScheduledDepartureTime;
    /**
     * The OALScheduledArrivalTime
     * @var string
     */
    public $OALScheduledArrivalTime;
    /**
     * The OALAirlinePersons
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOALAirlinePerson
     */
    public $OALAirlinePersons;
    /**
     * Constructor method for OALSegment
     * @uses OALSegment::setOALCarrierCode()
     * @uses OALSegment::setOALFlightNumber()
     * @uses OALSegment::setOALDepartureDate()
     * @uses OALSegment::setOALOrigin()
     * @uses OALSegment::setOALDestination()
     * @uses OALSegment::setOALScheduledDepartureTime()
     * @uses OALSegment::setOALScheduledArrivalTime()
     * @uses OALSegment::setOALAirlinePersons()
     * @param string $oALCarrierCode
     * @param string $oALFlightNumber
     * @param string $oALDepartureDate
     * @param string $oALOrigin
     * @param string $oALDestination
     * @param string $oALScheduledDepartureTime
     * @param string $oALScheduledArrivalTime
     * @param \ArrayType\ArrayOfOALAirlinePerson $oALAirlinePersons
     */
    public function __construct($oALCarrierCode = null, $oALFlightNumber = null, $oALDepartureDate = null, $oALOrigin = null, $oALDestination = null, $oALScheduledDepartureTime = null, $oALScheduledArrivalTime = null, \ArrayType\ArrayOfOALAirlinePerson $oALAirlinePersons = null)
    {
        $this
            ->setOALCarrierCode($oALCarrierCode)
            ->setOALFlightNumber($oALFlightNumber)
            ->setOALDepartureDate($oALDepartureDate)
            ->setOALOrigin($oALOrigin)
            ->setOALDestination($oALDestination)
            ->setOALScheduledDepartureTime($oALScheduledDepartureTime)
            ->setOALScheduledArrivalTime($oALScheduledArrivalTime)
            ->setOALAirlinePersons($oALAirlinePersons);
    }
    /**
     * Get OALCarrierCode value
     * @return string|null
     */
    public function getOALCarrierCode()
    {
        return $this->OALCarrierCode;
    }
    /**
     * Set OALCarrierCode value
     * @param string $oALCarrierCode
     * @return \StructType\OALSegment
     */
    public function setOALCarrierCode($oALCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($oALCarrierCode) && !is_string($oALCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALCarrierCode, true), gettype($oALCarrierCode)), __LINE__);
        }
        $this->OALCarrierCode = $oALCarrierCode;
        return $this;
    }
    /**
     * Get OALFlightNumber value
     * @return string|null
     */
    public function getOALFlightNumber()
    {
        return $this->OALFlightNumber;
    }
    /**
     * Set OALFlightNumber value
     * @param string $oALFlightNumber
     * @return \StructType\OALSegment
     */
    public function setOALFlightNumber($oALFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($oALFlightNumber) && !is_string($oALFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALFlightNumber, true), gettype($oALFlightNumber)), __LINE__);
        }
        $this->OALFlightNumber = $oALFlightNumber;
        return $this;
    }
    /**
     * Get OALDepartureDate value
     * @return string|null
     */
    public function getOALDepartureDate()
    {
        return $this->OALDepartureDate;
    }
    /**
     * Set OALDepartureDate value
     * @param string $oALDepartureDate
     * @return \StructType\OALSegment
     */
    public function setOALDepartureDate($oALDepartureDate = null)
    {
        // validation for constraint: string
        if (!is_null($oALDepartureDate) && !is_string($oALDepartureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALDepartureDate, true), gettype($oALDepartureDate)), __LINE__);
        }
        $this->OALDepartureDate = $oALDepartureDate;
        return $this;
    }
    /**
     * Get OALOrigin value
     * @return string|null
     */
    public function getOALOrigin()
    {
        return $this->OALOrigin;
    }
    /**
     * Set OALOrigin value
     * @param string $oALOrigin
     * @return \StructType\OALSegment
     */
    public function setOALOrigin($oALOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($oALOrigin) && !is_string($oALOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALOrigin, true), gettype($oALOrigin)), __LINE__);
        }
        $this->OALOrigin = $oALOrigin;
        return $this;
    }
    /**
     * Get OALDestination value
     * @return string|null
     */
    public function getOALDestination()
    {
        return $this->OALDestination;
    }
    /**
     * Set OALDestination value
     * @param string $oALDestination
     * @return \StructType\OALSegment
     */
    public function setOALDestination($oALDestination = null)
    {
        // validation for constraint: string
        if (!is_null($oALDestination) && !is_string($oALDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALDestination, true), gettype($oALDestination)), __LINE__);
        }
        $this->OALDestination = $oALDestination;
        return $this;
    }
    /**
     * Get OALScheduledDepartureTime value
     * @return string|null
     */
    public function getOALScheduledDepartureTime()
    {
        return $this->OALScheduledDepartureTime;
    }
    /**
     * Set OALScheduledDepartureTime value
     * @param string $oALScheduledDepartureTime
     * @return \StructType\OALSegment
     */
    public function setOALScheduledDepartureTime($oALScheduledDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($oALScheduledDepartureTime) && !is_string($oALScheduledDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALScheduledDepartureTime, true), gettype($oALScheduledDepartureTime)), __LINE__);
        }
        $this->OALScheduledDepartureTime = $oALScheduledDepartureTime;
        return $this;
    }
    /**
     * Get OALScheduledArrivalTime value
     * @return string|null
     */
    public function getOALScheduledArrivalTime()
    {
        return $this->OALScheduledArrivalTime;
    }
    /**
     * Set OALScheduledArrivalTime value
     * @param string $oALScheduledArrivalTime
     * @return \StructType\OALSegment
     */
    public function setOALScheduledArrivalTime($oALScheduledArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($oALScheduledArrivalTime) && !is_string($oALScheduledArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALScheduledArrivalTime, true), gettype($oALScheduledArrivalTime)), __LINE__);
        }
        $this->OALScheduledArrivalTime = $oALScheduledArrivalTime;
        return $this;
    }
    /**
     * Get OALAirlinePersons value
     * @return \ArrayType\ArrayOfOALAirlinePerson|null
     */
    public function getOALAirlinePersons()
    {
        return $this->OALAirlinePersons;
    }
    /**
     * Set OALAirlinePersons value
     * @param \ArrayType\ArrayOfOALAirlinePerson $oALAirlinePersons
     * @return \StructType\OALSegment
     */
    public function setOALAirlinePersons(\ArrayType\ArrayOfOALAirlinePerson $oALAirlinePersons = null)
    {
        $this->OALAirlinePersons = $oALAirlinePersons;
        return $this;
    }
}
