<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OAFlightSegments StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OAFlightSegments
 * @subpackage Structs
 */
class OAFlightSegments extends TransactionInfo
{
    /**
     * The OAFlightSegmentsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OAFlightSegments
     */
    public $OAFlightSegmentsRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The OALFlightKeyToRemove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OALFlightKeyToRemove;
    /**
     * The OALPaxRecordNumbersToRemove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $OALPaxRecordNumbersToRemove;
    /**
     * The OALSegmentsToAdd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOALSegment
     */
    public $OALSegmentsToAdd;
    /**
     * Constructor method for OAFlightSegments
     * @uses OAFlightSegments::setOAFlightSegmentsRequest()
     * @uses OAFlightSegments::setActionType()
     * @uses OAFlightSegments::setReservationInfo()
     * @uses OAFlightSegments::setOALFlightKeyToRemove()
     * @uses OAFlightSegments::setOALPaxRecordNumbersToRemove()
     * @uses OAFlightSegments::setOALSegmentsToAdd()
     * @param \StructType\OAFlightSegments $oAFlightSegmentsRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $oALFlightKeyToRemove
     * @param \ArrayType\ArrayOfint $oALPaxRecordNumbersToRemove
     * @param \ArrayType\ArrayOfOALSegment $oALSegmentsToAdd
     */
    public function __construct(\StructType\OAFlightSegments $oAFlightSegmentsRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, $oALFlightKeyToRemove = null, \ArrayType\ArrayOfint $oALPaxRecordNumbersToRemove = null, \ArrayType\ArrayOfOALSegment $oALSegmentsToAdd = null)
    {
        $this
            ->setOAFlightSegmentsRequest($oAFlightSegmentsRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setOALFlightKeyToRemove($oALFlightKeyToRemove)
            ->setOALPaxRecordNumbersToRemove($oALPaxRecordNumbersToRemove)
            ->setOALSegmentsToAdd($oALSegmentsToAdd);
    }
    /**
     * Get OAFlightSegmentsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OAFlightSegments|null
     */
    public function getOAFlightSegmentsRequest()
    {
        return isset($this->OAFlightSegmentsRequest) ? $this->OAFlightSegmentsRequest : null;
    }
    /**
     * Set OAFlightSegmentsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OAFlightSegments $oAFlightSegmentsRequest
     * @return \StructType\OAFlightSegments
     */
    public function setOAFlightSegmentsRequest(\StructType\OAFlightSegments $oAFlightSegmentsRequest = null)
    {
        if (is_null($oAFlightSegmentsRequest) || (is_array($oAFlightSegmentsRequest) && empty($oAFlightSegmentsRequest))) {
            unset($this->OAFlightSegmentsRequest);
        } else {
            $this->OAFlightSegmentsRequest = $oAFlightSegmentsRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\OAFlightSegments_ActionTypes::valueIsValid()
     * @uses \EnumType\OAFlightSegments_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\OAFlightSegments
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OAFlightSegments_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OAFlightSegments_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\OAFlightSegments_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\OAFlightSegments
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get OALFlightKeyToRemove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOALFlightKeyToRemove()
    {
        return isset($this->OALFlightKeyToRemove) ? $this->OALFlightKeyToRemove : null;
    }
    /**
     * Set OALFlightKeyToRemove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oALFlightKeyToRemove
     * @return \StructType\OAFlightSegments
     */
    public function setOALFlightKeyToRemove($oALFlightKeyToRemove = null)
    {
        // validation for constraint: string
        if (!is_null($oALFlightKeyToRemove) && !is_string($oALFlightKeyToRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oALFlightKeyToRemove, true), gettype($oALFlightKeyToRemove)), __LINE__);
        }
        if (is_null($oALFlightKeyToRemove) || (is_array($oALFlightKeyToRemove) && empty($oALFlightKeyToRemove))) {
            unset($this->OALFlightKeyToRemove);
        } else {
            $this->OALFlightKeyToRemove = $oALFlightKeyToRemove;
        }
        return $this;
    }
    /**
     * Get OALPaxRecordNumbersToRemove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getOALPaxRecordNumbersToRemove()
    {
        return isset($this->OALPaxRecordNumbersToRemove) ? $this->OALPaxRecordNumbersToRemove : null;
    }
    /**
     * Set OALPaxRecordNumbersToRemove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $oALPaxRecordNumbersToRemove
     * @return \StructType\OAFlightSegments
     */
    public function setOALPaxRecordNumbersToRemove(\ArrayType\ArrayOfint $oALPaxRecordNumbersToRemove = null)
    {
        if (is_null($oALPaxRecordNumbersToRemove) || (is_array($oALPaxRecordNumbersToRemove) && empty($oALPaxRecordNumbersToRemove))) {
            unset($this->OALPaxRecordNumbersToRemove);
        } else {
            $this->OALPaxRecordNumbersToRemove = $oALPaxRecordNumbersToRemove;
        }
        return $this;
    }
    /**
     * Get OALSegmentsToAdd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOALSegment|null
     */
    public function getOALSegmentsToAdd()
    {
        return isset($this->OALSegmentsToAdd) ? $this->OALSegmentsToAdd : null;
    }
    /**
     * Set OALSegmentsToAdd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOALSegment $oALSegmentsToAdd
     * @return \StructType\OAFlightSegments
     */
    public function setOALSegmentsToAdd(\ArrayType\ArrayOfOALSegment $oALSegmentsToAdd = null)
    {
        if (is_null($oALSegmentsToAdd) || (is_array($oALSegmentsToAdd) && empty($oALSegmentsToAdd))) {
            unset($this->OALSegmentsToAdd);
        } else {
            $this->OALSegmentsToAdd = $oALSegmentsToAdd;
        }
        return $this;
    }
}
