<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR.UpdatePassengerGrouping StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR.UpdatePassengerGrouping
 * @subpackage Structs
 */
class ModifyPNR_UpdatePassengerGrouping extends AbstractStructBase
{
    /**
     * The PersonOrgId
     * @var int
     */
    public $PersonOrgId;
    /**
     * The NewGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NewGroupId;
    /**
     * The CheckInLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckInLocator;
    /**
     * Constructor method for ModifyPNR.UpdatePassengerGrouping
     * @uses ModifyPNR_UpdatePassengerGrouping::setPersonOrgId()
     * @uses ModifyPNR_UpdatePassengerGrouping::setNewGroupId()
     * @uses ModifyPNR_UpdatePassengerGrouping::setCheckInLocator()
     * @param int $personOrgId
     * @param int $newGroupId
     * @param string $checkInLocator
     */
    public function __construct($personOrgId = null, $newGroupId = null, $checkInLocator = null)
    {
        $this
            ->setPersonOrgId($personOrgId)
            ->setNewGroupId($newGroupId)
            ->setCheckInLocator($checkInLocator);
    }
    /**
     * Get PersonOrgId value
     * @return int|null
     */
    public function getPersonOrgId()
    {
        return $this->PersonOrgId;
    }
    /**
     * Set PersonOrgId value
     * @param int $personOrgId
     * @return \StructType\ModifyPNR_UpdatePassengerGrouping
     */
    public function setPersonOrgId($personOrgId = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgId) && !(is_int($personOrgId) || ctype_digit($personOrgId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgId, true), gettype($personOrgId)), __LINE__);
        }
        $this->PersonOrgId = $personOrgId;
        return $this;
    }
    /**
     * Get NewGroupId value
     * @return int|null
     */
    public function getNewGroupId()
    {
        return $this->NewGroupId;
    }
    /**
     * Set NewGroupId value
     * @param int $newGroupId
     * @return \StructType\ModifyPNR_UpdatePassengerGrouping
     */
    public function setNewGroupId($newGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($newGroupId) && !(is_int($newGroupId) || ctype_digit($newGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newGroupId, true), gettype($newGroupId)), __LINE__);
        }
        $this->NewGroupId = $newGroupId;
        return $this;
    }
    /**
     * Get CheckInLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckInLocator()
    {
        return isset($this->CheckInLocator) ? $this->CheckInLocator : null;
    }
    /**
     * Set CheckInLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkInLocator
     * @return \StructType\ModifyPNR_UpdatePassengerGrouping
     */
    public function setCheckInLocator($checkInLocator = null)
    {
        // validation for constraint: string
        if (!is_null($checkInLocator) && !is_string($checkInLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInLocator, true), gettype($checkInLocator)), __LINE__);
        }
        if (is_null($checkInLocator) || (is_array($checkInLocator) && empty($checkInLocator))) {
            unset($this->CheckInLocator);
        } else {
            $this->CheckInLocator = $checkInLocator;
        }
        return $this;
    }
}
