<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR.Passenger StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR.Passenger
 * @subpackage Structs
 */
class ModifyPNR_Passenger extends ModifyPNR_Person
{
    /**
     * The DropOffID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DropOffID;
    /**
     * The PickUpID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickUpID;
    /**
     * The LapChildID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LapChildID;
    /**
     * The FrequentFlyerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * The SelecteeStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SelecteeStatus;
    /**
     * The StoreFrontID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StoreFrontID;
    /**
     * The TravelsWithPersonOrgID
     * @var int
     */
    public $TravelsWithPersonOrgID;
    /**
     * The RedressNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RedressNumber;
    /**
     * The KnownTravelerNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $KnownTravelerNumber;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The FlightInformations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfModifyPNR_FlightInformation
     */
    public $FlightInformations;
    /**
     * Constructor method for ModifyPNR.Passenger
     * @uses ModifyPNR_Passenger::setDropOffID()
     * @uses ModifyPNR_Passenger::setPickUpID()
     * @uses ModifyPNR_Passenger::setLapChildID()
     * @uses ModifyPNR_Passenger::setFrequentFlyerNumber()
     * @uses ModifyPNR_Passenger::setSelecteeStatus()
     * @uses ModifyPNR_Passenger::setStoreFrontID()
     * @uses ModifyPNR_Passenger::setTravelsWithPersonOrgID()
     * @uses ModifyPNR_Passenger::setRedressNumber()
     * @uses ModifyPNR_Passenger::setKnownTravelerNumber()
     * @uses ModifyPNR_Passenger::setRecordLocator()
     * @uses ModifyPNR_Passenger::setFlightInformations()
     * @param int $dropOffID
     * @param int $pickUpID
     * @param int $lapChildID
     * @param string $frequentFlyerNumber
     * @param int $selecteeStatus
     * @param string $storeFrontID
     * @param int $travelsWithPersonOrgID
     * @param string $redressNumber
     * @param string $knownTravelerNumber
     * @param string $recordLocator
     * @param \ArrayType\ArrayOfModifyPNR_FlightInformation $flightInformations
     */
    public function __construct($dropOffID = null, $pickUpID = null, $lapChildID = null, $frequentFlyerNumber = null, $selecteeStatus = null, $storeFrontID = null, $travelsWithPersonOrgID = null, $redressNumber = null, $knownTravelerNumber = null, $recordLocator = null, \ArrayType\ArrayOfModifyPNR_FlightInformation $flightInformations = null)
    {
        $this
            ->setDropOffID($dropOffID)
            ->setPickUpID($pickUpID)
            ->setLapChildID($lapChildID)
            ->setFrequentFlyerNumber($frequentFlyerNumber)
            ->setSelecteeStatus($selecteeStatus)
            ->setStoreFrontID($storeFrontID)
            ->setTravelsWithPersonOrgID($travelsWithPersonOrgID)
            ->setRedressNumber($redressNumber)
            ->setKnownTravelerNumber($knownTravelerNumber)
            ->setRecordLocator($recordLocator)
            ->setFlightInformations($flightInformations);
    }
    /**
     * Get DropOffID value
     * @return int|null
     */
    public function getDropOffID()
    {
        return $this->DropOffID;
    }
    /**
     * Set DropOffID value
     * @param int $dropOffID
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setDropOffID($dropOffID = null)
    {
        // validation for constraint: int
        if (!is_null($dropOffID) && !(is_int($dropOffID) || ctype_digit($dropOffID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dropOffID, true), gettype($dropOffID)), __LINE__);
        }
        $this->DropOffID = $dropOffID;
        return $this;
    }
    /**
     * Get PickUpID value
     * @return int|null
     */
    public function getPickUpID()
    {
        return $this->PickUpID;
    }
    /**
     * Set PickUpID value
     * @param int $pickUpID
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setPickUpID($pickUpID = null)
    {
        // validation for constraint: int
        if (!is_null($pickUpID) && !(is_int($pickUpID) || ctype_digit($pickUpID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickUpID, true), gettype($pickUpID)), __LINE__);
        }
        $this->PickUpID = $pickUpID;
        return $this;
    }
    /**
     * Get LapChildID value
     * @return int|null
     */
    public function getLapChildID()
    {
        return $this->LapChildID;
    }
    /**
     * Set LapChildID value
     * @param int $lapChildID
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setLapChildID($lapChildID = null)
    {
        // validation for constraint: int
        if (!is_null($lapChildID) && !(is_int($lapChildID) || ctype_digit($lapChildID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lapChildID, true), gettype($lapChildID)), __LINE__);
        }
        $this->LapChildID = $lapChildID;
        return $this;
    }
    /**
     * Get FrequentFlyerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return isset($this->FrequentFlyerNumber) ? $this->FrequentFlyerNumber : null;
    }
    /**
     * Set FrequentFlyerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerNumber
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumber) && !is_string($frequentFlyerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerNumber, true), gettype($frequentFlyerNumber)), __LINE__);
        }
        if (is_null($frequentFlyerNumber) || (is_array($frequentFlyerNumber) && empty($frequentFlyerNumber))) {
            unset($this->FrequentFlyerNumber);
        } else {
            $this->FrequentFlyerNumber = $frequentFlyerNumber;
        }
        return $this;
    }
    /**
     * Get SelecteeStatus value
     * @return int|null
     */
    public function getSelecteeStatus()
    {
        return $this->SelecteeStatus;
    }
    /**
     * Set SelecteeStatus value
     * @param int $selecteeStatus
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setSelecteeStatus($selecteeStatus = null)
    {
        // validation for constraint: int
        if (!is_null($selecteeStatus) && !(is_int($selecteeStatus) || ctype_digit($selecteeStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selecteeStatus, true), gettype($selecteeStatus)), __LINE__);
        }
        $this->SelecteeStatus = $selecteeStatus;
        return $this;
    }
    /**
     * Get StoreFrontID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStoreFrontID()
    {
        return isset($this->StoreFrontID) ? $this->StoreFrontID : null;
    }
    /**
     * Set StoreFrontID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $storeFrontID
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setStoreFrontID($storeFrontID = null)
    {
        // validation for constraint: string
        if (!is_null($storeFrontID) && !is_string($storeFrontID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeFrontID, true), gettype($storeFrontID)), __LINE__);
        }
        if (is_null($storeFrontID) || (is_array($storeFrontID) && empty($storeFrontID))) {
            unset($this->StoreFrontID);
        } else {
            $this->StoreFrontID = $storeFrontID;
        }
        return $this;
    }
    /**
     * Get TravelsWithPersonOrgID value
     * @return int|null
     */
    public function getTravelsWithPersonOrgID()
    {
        return $this->TravelsWithPersonOrgID;
    }
    /**
     * Set TravelsWithPersonOrgID value
     * @param int $travelsWithPersonOrgID
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setTravelsWithPersonOrgID($travelsWithPersonOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($travelsWithPersonOrgID) && !(is_int($travelsWithPersonOrgID) || ctype_digit($travelsWithPersonOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelsWithPersonOrgID, true), gettype($travelsWithPersonOrgID)), __LINE__);
        }
        $this->TravelsWithPersonOrgID = $travelsWithPersonOrgID;
        return $this;
    }
    /**
     * Get RedressNumber value
     * @return string|null
     */
    public function getRedressNumber()
    {
        return $this->RedressNumber;
    }
    /**
     * Set RedressNumber value
     * @param string $redressNumber
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setRedressNumber($redressNumber = null)
    {
        // validation for constraint: string
        if (!is_null($redressNumber) && !is_string($redressNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redressNumber, true), gettype($redressNumber)), __LINE__);
        }
        $this->RedressNumber = $redressNumber;
        return $this;
    }
    /**
     * Get KnownTravelerNumber value
     * @return string|null
     */
    public function getKnownTravelerNumber()
    {
        return $this->KnownTravelerNumber;
    }
    /**
     * Set KnownTravelerNumber value
     * @param string $knownTravelerNumber
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setKnownTravelerNumber($knownTravelerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($knownTravelerNumber) && !is_string($knownTravelerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knownTravelerNumber, true), gettype($knownTravelerNumber)), __LINE__);
        }
        $this->KnownTravelerNumber = $knownTravelerNumber;
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
    /**
     * Get FlightInformations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfModifyPNR_FlightInformation|null
     */
    public function getFlightInformations()
    {
        return isset($this->FlightInformations) ? $this->FlightInformations : null;
    }
    /**
     * Set FlightInformations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfModifyPNR_FlightInformation $flightInformations
     * @return \StructType\ModifyPNR_Passenger
     */
    public function setFlightInformations(\ArrayType\ArrayOfModifyPNR_FlightInformation $flightInformations = null)
    {
        if (is_null($flightInformations) || (is_array($flightInformations) && empty($flightInformations))) {
            unset($this->FlightInformations);
        } else {
            $this->FlightInformations = $flightInformations;
        }
        return $this;
    }
}
