<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPNR.EmergencyContact StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyPNR.EmergencyContact
 * @subpackage Structs
 */
class ModifyPNR_EmergencyContact extends AbstractStructBase
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The DOB
     * @var string
     */
    public $DOB;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The RelationType
     * @var string
     */
    public $RelationType;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The ContactType
     * @var string
     */
    public $ContactType;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ContactInformation;
    /**
     * The DisclosedEmergencyContact
     * @var bool
     */
    public $DisclosedEmergencyContact;
    /**
     * The ReservationKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReservationKey;
    /**
     * The LogicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKey;
    /**
     * The PhysicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhysicalFlightKey;
    /**
     * The CustomerKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomerKey;
    /**
     * The AirlinePersonKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirlinePersonKey;
    /**
     * Constructor method for ModifyPNR.EmergencyContact
     * @uses ModifyPNR_EmergencyContact::setTitle()
     * @uses ModifyPNR_EmergencyContact::setFirstName()
     * @uses ModifyPNR_EmergencyContact::setLastName()
     * @uses ModifyPNR_EmergencyContact::setMiddleName()
     * @uses ModifyPNR_EmergencyContact::setAge()
     * @uses ModifyPNR_EmergencyContact::setDOB()
     * @uses ModifyPNR_EmergencyContact::setGender()
     * @uses ModifyPNR_EmergencyContact::setRelationType()
     * @uses ModifyPNR_EmergencyContact::setAddress()
     * @uses ModifyPNR_EmergencyContact::setCompany()
     * @uses ModifyPNR_EmergencyContact::setComments()
     * @uses ModifyPNR_EmergencyContact::setContactType()
     * @uses ModifyPNR_EmergencyContact::setContactInformation()
     * @uses ModifyPNR_EmergencyContact::setDisclosedEmergencyContact()
     * @uses ModifyPNR_EmergencyContact::setReservationKey()
     * @uses ModifyPNR_EmergencyContact::setLogicalFlightKey()
     * @uses ModifyPNR_EmergencyContact::setPhysicalFlightKey()
     * @uses ModifyPNR_EmergencyContact::setCustomerKey()
     * @uses ModifyPNR_EmergencyContact::setAirlinePersonKey()
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     * @param string $middleName
     * @param int $age
     * @param string $dOB
     * @param string $gender
     * @param string $relationType
     * @param \StructType\Address $address
     * @param string $company
     * @param string $comments
     * @param string $contactType
     * @param string $contactInformation
     * @param bool $disclosedEmergencyContact
     * @param string $reservationKey
     * @param string $logicalFlightKey
     * @param string $physicalFlightKey
     * @param string $customerKey
     * @param string $airlinePersonKey
     */
    public function __construct($title = null, $firstName = null, $lastName = null, $middleName = null, $age = null, $dOB = null, $gender = null, $relationType = null, \StructType\Address $address = null, $company = null, $comments = null, $contactType = null, $contactInformation = null, $disclosedEmergencyContact = null, $reservationKey = null, $logicalFlightKey = null, $physicalFlightKey = null, $customerKey = null, $airlinePersonKey = null)
    {
        $this
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setAge($age)
            ->setDOB($dOB)
            ->setGender($gender)
            ->setRelationType($relationType)
            ->setAddress($address)
            ->setCompany($company)
            ->setComments($comments)
            ->setContactType($contactType)
            ->setContactInformation($contactInformation)
            ->setDisclosedEmergencyContact($disclosedEmergencyContact)
            ->setReservationKey($reservationKey)
            ->setLogicalFlightKey($logicalFlightKey)
            ->setPhysicalFlightKey($physicalFlightKey)
            ->setCustomerKey($customerKey)
            ->setAirlinePersonKey($airlinePersonKey);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Enumerations_GenderTypes::valueIsValid()
     * @uses \EnumType\Enumerations_GenderTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_GenderTypes::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_GenderTypes', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\Enumerations_GenderTypes::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get RelationType value
     * @return string|null
     */
    public function getRelationType()
    {
        return $this->RelationType;
    }
    /**
     * Set RelationType value
     * @uses \EnumType\Enumerations_RelationshipTypes::valueIsValid()
     * @uses \EnumType\Enumerations_RelationshipTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationType
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setRelationType($relationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_RelationshipTypes::valueIsValid($relationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_RelationshipTypes', is_array($relationType) ? implode(', ', $relationType) : var_export($relationType, true), implode(', ', \EnumType\Enumerations_RelationshipTypes::getValidValues())), __LINE__);
        }
        $this->RelationType = $relationType;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @uses \EnumType\Enumerations_ContactTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ContactTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactType
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ContactTypes::valueIsValid($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ContactTypes', is_array($contactType) ? implode(', ', $contactType) : var_export($contactType, true), implode(', ', \EnumType\Enumerations_ContactTypes::getValidValues())), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return string|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * Set ContactInformation value
     * @param string $contactInformation
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setContactInformation($contactInformation = null)
    {
        // validation for constraint: string
        if (!is_null($contactInformation) && !is_string($contactInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInformation, true), gettype($contactInformation)), __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Get DisclosedEmergencyContact value
     * @return bool|null
     */
    public function getDisclosedEmergencyContact()
    {
        return $this->DisclosedEmergencyContact;
    }
    /**
     * Set DisclosedEmergencyContact value
     * @param bool $disclosedEmergencyContact
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setDisclosedEmergencyContact($disclosedEmergencyContact = null)
    {
        // validation for constraint: boolean
        if (!is_null($disclosedEmergencyContact) && !is_bool($disclosedEmergencyContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disclosedEmergencyContact, true), gettype($disclosedEmergencyContact)), __LINE__);
        }
        $this->DisclosedEmergencyContact = $disclosedEmergencyContact;
        return $this;
    }
    /**
     * Get ReservationKey value
     * @return string|null
     */
    public function getReservationKey()
    {
        return $this->ReservationKey;
    }
    /**
     * Set ReservationKey value
     * @param string $reservationKey
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setReservationKey($reservationKey = null)
    {
        // validation for constraint: string
        if (!is_null($reservationKey) && !is_string($reservationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationKey, true), gettype($reservationKey)), __LINE__);
        }
        $this->ReservationKey = $reservationKey;
        return $this;
    }
    /**
     * Get LogicalFlightKey value
     * @return string|null
     */
    public function getLogicalFlightKey()
    {
        return $this->LogicalFlightKey;
    }
    /**
     * Set LogicalFlightKey value
     * @param string $logicalFlightKey
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setLogicalFlightKey($logicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKey) && !is_string($logicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKey, true), gettype($logicalFlightKey)), __LINE__);
        }
        $this->LogicalFlightKey = $logicalFlightKey;
        return $this;
    }
    /**
     * Get PhysicalFlightKey value
     * @return string|null
     */
    public function getPhysicalFlightKey()
    {
        return $this->PhysicalFlightKey;
    }
    /**
     * Set PhysicalFlightKey value
     * @param string $physicalFlightKey
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setPhysicalFlightKey($physicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFlightKey) && !is_string($physicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFlightKey, true), gettype($physicalFlightKey)), __LINE__);
        }
        $this->PhysicalFlightKey = $physicalFlightKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get AirlinePersonKey value
     * @return string|null
     */
    public function getAirlinePersonKey()
    {
        return $this->AirlinePersonKey;
    }
    /**
     * Set AirlinePersonKey value
     * @param string $airlinePersonKey
     * @return \StructType\ModifyPNR_EmergencyContact
     */
    public function setAirlinePersonKey($airlinePersonKey = null)
    {
        // validation for constraint: string
        if (!is_null($airlinePersonKey) && !is_string($airlinePersonKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlinePersonKey, true), gettype($airlinePersonKey)), __LINE__);
        }
        $this->AirlinePersonKey = $airlinePersonKey;
        return $this;
    }
}
