<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManualRefundCharges StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ManualRefundCharges
 * @subpackage Structs
 */
class ManualRefundCharges extends TransactionInfo
{
    /**
     * The ManualRefundChargesRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ManualRefundCharges
     */
    public $ManualRefundChargesRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The RefundOption
     * @var string
     */
    public $RefundOption;
    /**
     * The ManualRefundReason
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ManualRefundReason;
    /**
     * The RefundChargeDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfRefundChargeDetail
     */
    public $RefundChargeDetails;
    /**
     * Constructor method for ManualRefundCharges
     * @uses ManualRefundCharges::setManualRefundChargesRequest()
     * @uses ManualRefundCharges::setReservationInfo()
     * @uses ManualRefundCharges::setRefundOption()
     * @uses ManualRefundCharges::setManualRefundReason()
     * @uses ManualRefundCharges::setRefundChargeDetails()
     * @param \StructType\ManualRefundCharges $manualRefundChargesRequest
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $refundOption
     * @param string $manualRefundReason
     * @param \ArrayType\ArrayOfRefundChargeDetail $refundChargeDetails
     */
    public function __construct(\StructType\ManualRefundCharges $manualRefundChargesRequest = null, \StructType\ReservationInfo $reservationInfo = null, $refundOption = null, $manualRefundReason = null, \ArrayType\ArrayOfRefundChargeDetail $refundChargeDetails = null)
    {
        $this
            ->setManualRefundChargesRequest($manualRefundChargesRequest)
            ->setReservationInfo($reservationInfo)
            ->setRefundOption($refundOption)
            ->setManualRefundReason($manualRefundReason)
            ->setRefundChargeDetails($refundChargeDetails);
    }
    /**
     * Get ManualRefundChargesRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ManualRefundCharges|null
     */
    public function getManualRefundChargesRequest()
    {
        return isset($this->ManualRefundChargesRequest) ? $this->ManualRefundChargesRequest : null;
    }
    /**
     * Set ManualRefundChargesRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ManualRefundCharges $manualRefundChargesRequest
     * @return \StructType\ManualRefundCharges
     */
    public function setManualRefundChargesRequest(\StructType\ManualRefundCharges $manualRefundChargesRequest = null)
    {
        if (is_null($manualRefundChargesRequest) || (is_array($manualRefundChargesRequest) && empty($manualRefundChargesRequest))) {
            unset($this->ManualRefundChargesRequest);
        } else {
            $this->ManualRefundChargesRequest = $manualRefundChargesRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\ManualRefundCharges
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get RefundOption value
     * @return string|null
     */
    public function getRefundOption()
    {
        return $this->RefundOption;
    }
    /**
     * Set RefundOption value
     * @uses \EnumType\ManualRefundCharges_RefundOptions::valueIsValid()
     * @uses \EnumType\ManualRefundCharges_RefundOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $refundOption
     * @return \StructType\ManualRefundCharges
     */
    public function setRefundOption($refundOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManualRefundCharges_RefundOptions::valueIsValid($refundOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManualRefundCharges_RefundOptions', is_array($refundOption) ? implode(', ', $refundOption) : var_export($refundOption, true), implode(', ', \EnumType\ManualRefundCharges_RefundOptions::getValidValues())), __LINE__);
        }
        $this->RefundOption = $refundOption;
        return $this;
    }
    /**
     * Get ManualRefundReason value
     * @return string|null
     */
    public function getManualRefundReason()
    {
        return $this->ManualRefundReason;
    }
    /**
     * Set ManualRefundReason value
     * @param string $manualRefundReason
     * @return \StructType\ManualRefundCharges
     */
    public function setManualRefundReason($manualRefundReason = null)
    {
        // validation for constraint: string
        if (!is_null($manualRefundReason) && !is_string($manualRefundReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manualRefundReason, true), gettype($manualRefundReason)), __LINE__);
        }
        $this->ManualRefundReason = $manualRefundReason;
        return $this;
    }
    /**
     * Get RefundChargeDetails value
     * @return \ArrayType\ArrayOfRefundChargeDetail|null
     */
    public function getRefundChargeDetails()
    {
        return $this->RefundChargeDetails;
    }
    /**
     * Set RefundChargeDetails value
     * @param \ArrayType\ArrayOfRefundChargeDetail $refundChargeDetails
     * @return \StructType\ManualRefundCharges
     */
    public function setRefundChargeDetails(\ArrayType\ArrayOfRefundChargeDetail $refundChargeDetails = null)
    {
        $this->RefundChargeDetails = $refundChargeDetails;
        return $this;
    }
}
