<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPNR.Reservation.Segment.AirlinePerson.Charge
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportPNR.Reservation.Segment.AirlinePerson.Charge
 * @subpackage Structs
 */
class ImportPNR_Reservation_Segment_AirlinePerson_Charge extends AbstractStructBase
{
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for ImportPNR.Reservation.Segment.AirlinePerson.Charge
     * @uses ImportPNR_Reservation_Segment_AirlinePerson_Charge::setCodeType()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson_Charge::setAmount()
     * @uses ImportPNR_Reservation_Segment_AirlinePerson_Charge::setCurrency()
     * @param string $codeType
     * @param float $amount
     * @param string $currency
     */
    public function __construct($codeType = null, $amount = null, $currency = null)
    {
        $this
            ->setCodeType($codeType)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get CodeType value
     * @return string|null
     */
    public function getCodeType()
    {
        return $this->CodeType;
    }
    /**
     * Set CodeType value
     * @param string $codeType
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson_Charge
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        $this->CodeType = $codeType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson_Charge
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\ImportPNR_Reservation_Segment_AirlinePerson_Charge
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
