<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HistoryPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HistoryPNR
 * @subpackage Structs
 */
class HistoryPNR extends TransactionInfo
{
    /**
     * The HistoryPNRRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HistoryPNR
     */
    public $HistoryPNRRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ReservationsToInsertHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReservationToInsertHistory
     */
    public $ReservationsToInsertHistory;
    /**
     * Constructor method for HistoryPNR
     * @uses HistoryPNR::setHistoryPNRRequest()
     * @uses HistoryPNR::setActionType()
     * @uses HistoryPNR::setReservationInfo()
     * @uses HistoryPNR::setReservationsToInsertHistory()
     * @param \StructType\HistoryPNR $historyPNRRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfReservationToInsertHistory $reservationsToInsertHistory
     */
    public function __construct(\StructType\HistoryPNR $historyPNRRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfReservationToInsertHistory $reservationsToInsertHistory = null)
    {
        $this
            ->setHistoryPNRRequest($historyPNRRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setReservationsToInsertHistory($reservationsToInsertHistory);
    }
    /**
     * Get HistoryPNRRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HistoryPNR|null
     */
    public function getHistoryPNRRequest()
    {
        return isset($this->HistoryPNRRequest) ? $this->HistoryPNRRequest : null;
    }
    /**
     * Set HistoryPNRRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HistoryPNR $historyPNRRequest
     * @return \StructType\HistoryPNR
     */
    public function setHistoryPNRRequest(\StructType\HistoryPNR $historyPNRRequest = null)
    {
        if (is_null($historyPNRRequest) || (is_array($historyPNRRequest) && empty($historyPNRRequest))) {
            unset($this->HistoryPNRRequest);
        } else {
            $this->HistoryPNRRequest = $historyPNRRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\HistoryPNR_ActionTypes::valueIsValid()
     * @uses \EnumType\HistoryPNR_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\HistoryPNR
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HistoryPNR_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HistoryPNR_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\HistoryPNR_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\HistoryPNR
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ReservationsToInsertHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReservationToInsertHistory|null
     */
    public function getReservationsToInsertHistory()
    {
        return isset($this->ReservationsToInsertHistory) ? $this->ReservationsToInsertHistory : null;
    }
    /**
     * Set ReservationsToInsertHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReservationToInsertHistory $reservationsToInsertHistory
     * @return \StructType\HistoryPNR
     */
    public function setReservationsToInsertHistory(\ArrayType\ArrayOfReservationToInsertHistory $reservationsToInsertHistory = null)
    {
        if (is_null($reservationsToInsertHistory) || (is_array($reservationsToInsertHistory) && empty($reservationsToInsertHistory))) {
            unset($this->ReservationsToInsertHistory);
        } else {
            $this->ReservationsToInsertHistory = $reservationsToInsertHistory;
        }
        return $this;
    }
}
