<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApisInfos StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApisInfos
 * @subpackage Structs
 */
class ApisInfos extends TransactionInfo
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The ApisInfos
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfApisInformation
     */
    public $ApisInfos;
    /**
     * Constructor method for ApisInfos
     * @uses ApisInfos::setSeriesNumber()
     * @uses ApisInfos::setConfirmationNumber()
     * @uses ApisInfos::setApisInfos()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param \ArrayType\ArrayOfApisInformation $apisInfos
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, \ArrayType\ArrayOfApisInformation $apisInfos = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setApisInfos($apisInfos);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ApisInfos
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ApisInfos
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get ApisInfos value
     * @return \ArrayType\ArrayOfApisInformation|null
     */
    public function getApisInfos()
    {
        return $this->ApisInfos;
    }
    /**
     * Set ApisInfos value
     * @param \ArrayType\ArrayOfApisInformation $apisInfos
     * @return \StructType\ApisInfos
     */
    public function setApisInfos(\ArrayType\ArrayOfApisInformation $apisInfos = null)
    {
        $this->ApisInfos = $apisInfos;
        return $this;
    }
}
