<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Postal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Postal;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The AreaCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AreaCode;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Display
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Display;
    /**
     * Constructor method for Address
     * @uses Address::setAddress1()
     * @uses Address::setAddress2()
     * @uses Address::setCity()
     * @uses Address::setState()
     * @uses Address::setPostal()
     * @uses Address::setCountry()
     * @uses Address::setCountryCode()
     * @uses Address::setAreaCode()
     * @uses Address::setPhoneNumber()
     * @uses Address::setDisplay()
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $postal
     * @param string $country
     * @param string $countryCode
     * @param string $areaCode
     * @param string $phoneNumber
     * @param string $display
     */
    public function __construct($address1 = null, $address2 = null, $city = null, $state = null, $postal = null, $country = null, $countryCode = null, $areaCode = null, $phoneNumber = null, $display = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setPostal($postal)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setAreaCode($areaCode)
            ->setPhoneNumber($phoneNumber)
            ->setDisplay($display);
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\Address
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Address
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Postal value
     * @return string|null
     */
    public function getPostal()
    {
        return $this->Postal;
    }
    /**
     * Set Postal value
     * @param string $postal
     * @return \StructType\Address
     */
    public function setPostal($postal = null)
    {
        // validation for constraint: string
        if (!is_null($postal) && !is_string($postal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postal, true), gettype($postal)), __LINE__);
        }
        $this->Postal = $postal;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Address
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get AreaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->AreaCode;
    }
    /**
     * Set AreaCode value
     * @param string $areaCode
     * @return \StructType\Address
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaCode) && !is_string($areaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCode, true), gettype($areaCode)), __LINE__);
        }
        $this->AreaCode = $areaCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\Address
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->Display;
    }
    /**
     * Set Display value
     * @param string $display
     * @return \StructType\Address
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        $this->Display = $display;
        return $this;
    }
}
