<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrievePNR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrievePNR $parameters
     * @return \StructType\RetrievePNRResponse|bool
     */
    public function RetrievePNR(\StructType\RetrievePNR $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrievePNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveApisInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveApisInfo $parameters
     * @return \StructType\RetrieveApisInfoResponse|bool
     */
    public function RetrieveApisInfo(\StructType\RetrieveApisInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveApisInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrievePNRByRecordLocator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrievePNRByRecordLocator $parameters
     * @return \StructType\RetrievePNRByRecordLocatorResponse|bool
     */
    public function RetrievePNRByRecordLocator(\StructType\RetrievePNRByRecordLocator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrievePNRByRecordLocator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveApisInfoResponse|\StructType\RetrievePNRByRecordLocatorResponse|\StructType\RetrievePNRResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
